/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.tasks;

import java.util.Collection;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultFuture;
import org.datacleaner.api.HasAnalyzerResult;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectResultsTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CollectResultsTask.class);
    private final HasAnalyzerResult<?> _hasResult;
    private final Collection<JobAndResult> _results;
    private final AnalysisListener _analysisListener;
    private final AnalysisJob _job;
    private final ComponentJob _componentJob;

    public CollectResultsTask(HasAnalyzerResult<?> hasResult, AnalysisJob job, ComponentJob componentJob, Collection<JobAndResult> results, AnalysisListener analysisListener) {
        this._hasResult = hasResult;
        this._job = job;
        this._componentJob = componentJob;
        this._results = results;
        this._analysisListener = analysisListener;
    }

    public void execute() throws Exception {
        logger.debug("execute()");
        AnalyzerResult result = this._hasResult.getResult();
        this._analysisListener.componentSuccess(this._job, this._componentJob, result);
        if (result == null) {
            logger.warn("Result (from {}) was null", this._hasResult);
        } else {
            this._results.add(new JobAndResult(this._componentJob, result));
            if (result instanceof AnalyzerResultFuture) {
                AnalyzerResultFuture analyzerResult = (AnalyzerResultFuture)result;
                analyzerResult.get();
            }
        }
    }
}

