/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.tasks;

import java.util.Collection;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.runner.ActiveOutputDataStream;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializeTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(InitializeTask.class);
    private final LifeCycleHelper _lifeCycleHelper;
    private final RowProcessingPublisher _publisher;
    private final RowProcessingConsumer _consumer;

    public InitializeTask(LifeCycleHelper lifeCycleHelper, RowProcessingPublisher publisher, RowProcessingConsumer consumer) {
        this._lifeCycleHelper = lifeCycleHelper;
        this._publisher = publisher;
        this._consumer = consumer;
    }

    public void execute() throws Exception {
        logger.debug("execute()");
        InitializeTask.executeInternal(this._consumer, this._publisher, this._lifeCycleHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeInternal(RowProcessingConsumer consumer, RowProcessingPublisher publisher, LifeCycleHelper lifeCycleHelper) {
        RowProcessingConsumer rowProcessingConsumer = consumer;
        synchronized (rowProcessingConsumer) {
            int publisherCount = consumer.onPublisherInitialized(publisher);
            if (publisherCount == 1) {
                ComponentConfiguration configuration = consumer.getComponentJob().getConfiguration();
                ComponentDescriptor descriptor = consumer.getComponentJob().getDescriptor();
                Object component = consumer.getComponent();
                lifeCycleHelper.assignConfiguredProperties(descriptor, component, configuration);
                lifeCycleHelper.assignProvidedProperties(descriptor, component);
                lifeCycleHelper.validate(descriptor, component);
                Collection<ActiveOutputDataStream> activeOutputDataStreams = consumer.getActiveOutputDataStreams();
                for (ActiveOutputDataStream activeOutputDataStream : activeOutputDataStreams) {
                    activeOutputDataStream.initialize();
                    RowProcessingPublisher outputDataStreamPublisher = activeOutputDataStream.getPublisher();
                    for (RowProcessingConsumer outputDataStreamConsumer : outputDataStreamPublisher.getConsumers()) {
                        LifeCycleHelper outputDataStreamLifeCycleHelper = outputDataStreamPublisher.getPublishers().getConsumerSpecificLifeCycleHelper(consumer);
                        InitializeTask.executeInternal(outputDataStreamConsumer, outputDataStreamPublisher, outputDataStreamLifeCycleHelper);
                    }
                }
                lifeCycleHelper.initialize(descriptor, component);
            }
        }
    }

    public String toString() {
        return "InitializeTask[" + this._consumer + "]";
    }
}

