/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssignConfiguredPropertiesHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    AssignConfiguredPropertiesHelper() {
    }

    public void assignProperties(Object component, ComponentDescriptor<?> descriptor, ComponentConfiguration configuration) {
        Set configuredProperties = descriptor.getConfiguredProperties();
        for (ConfiguredPropertyDescriptor property : configuredProperties) {
            Object configuredValue = this.getValue(property, configuration);
            if (configuredValue == null) {
                this.setValue(property, component, null);
                continue;
            }
            if (property.isArray()) {
                this.setValue(property, component, configuredValue);
                continue;
            }
            if (configuredValue.getClass().isArray()) {
                if (Array.getLength(configuredValue) == 1) {
                    configuredValue = Array.get(configuredValue, 0);
                } else {
                    if (Array.getLength(configuredValue) > 1) {
                        throw new IllegalStateException("Cannot assign an array-value (" + Arrays.toString((Object[])configuredValue) + ") to a non-array property (" + property + ")");
                    }
                    configuredValue = null;
                }
            }
            this.setValue(property, component, configuredValue);
        }
    }

    protected void setValue(ConfiguredPropertyDescriptor property, Object component, Object value) {
        property.setValue(component, value);
    }

    protected Object getValue(ConfiguredPropertyDescriptor propertyDescriptor, ComponentConfiguration componentConfiguration) {
        Object value = componentConfiguration.getProperty(propertyDescriptor);
        this.logger.debug("Property '{}' in configuration: {}", (Object)propertyDescriptor.getName(), value);
        return value;
    }
}

