/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.util.Set;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.InjectionManagerFactory;
import org.datacleaner.configuration.InjectionPoint;
import org.datacleaner.descriptors.CloseMethodDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.InitializeMethodDescriptor;
import org.datacleaner.descriptors.PropertyDescriptor;
import org.datacleaner.descriptors.ProvidedPropertyDescriptor;
import org.datacleaner.descriptors.ValidateMethodDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.lifecycle.AssignConfiguredPropertiesHelper;
import org.datacleaner.lifecycle.PropertyInjectionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifeCycleHelper {
    private static final Logger logger = LoggerFactory.getLogger(LifeCycleHelper.class);
    private final InjectionManager _injectionManager;
    private final boolean _includeNonDistributedTasks;

    @Deprecated
    public LifeCycleHelper(InjectionManager injectionManager) {
        this(injectionManager, true);
    }

    public LifeCycleHelper(InjectionManager injectionManager, boolean includeNonDistributedTasks) {
        this._injectionManager = injectionManager;
        this._includeNonDistributedTasks = includeNonDistributedTasks;
    }

    public LifeCycleHelper(DataCleanerConfiguration configuration, AnalysisJob job, boolean includeNonDistributedTasks) {
        if (configuration == null) {
            this._injectionManager = null;
        } else {
            InjectionManagerFactory injectionManagerFactory = configuration.getEnvironment().getInjectionManagerFactory();
            this._injectionManager = job == null ? injectionManagerFactory.getInjectionManager(configuration) : injectionManagerFactory.getInjectionManager(configuration, job);
        }
        this._includeNonDistributedTasks = includeNonDistributedTasks;
    }

    public boolean isIncludeNonDistributedTasks() {
        return this._includeNonDistributedTasks;
    }

    public InjectionManager getInjectionManager() {
        return this._injectionManager;
    }

    public void assignConfiguredProperties(ComponentDescriptor<?> descriptor, Object component, ComponentConfiguration componentConfiguration) {
        AssignConfiguredPropertiesHelper helper = new AssignConfiguredPropertiesHelper();
        helper.assignProperties(component, descriptor, componentConfiguration);
    }

    public void assignProvidedProperties(ComponentDescriptor<?> descriptor, Object component) {
        Set providedDescriptors = descriptor.getProvidedProperties();
        for (ProvidedPropertyDescriptor providedDescriptor : providedDescriptors) {
            PropertyInjectionPoint injectionPoint = new PropertyInjectionPoint((PropertyDescriptor)providedDescriptor, component);
            Object value = this._injectionManager.getInstance((InjectionPoint)injectionPoint);
            providedDescriptor.setValue(component, value);
        }
    }

    public void validate(ComponentDescriptor<?> descriptor, Object component) {
        Set validateDescriptors = descriptor.getValidateMethods();
        for (ValidateMethodDescriptor validateDescriptor : validateDescriptors) {
            validateDescriptor.validate(component);
        }
    }

    public void initialize(ComponentDescriptor<?> descriptor, Object component) {
        Set initializeDescriptors = descriptor.getInitializeMethods();
        for (InitializeMethodDescriptor initializeDescriptor : initializeDescriptors) {
            if (!this._includeNonDistributedTasks && !initializeDescriptor.isDistributed()) continue;
            initializeDescriptor.initialize(component);
        }
    }

    public void close(ComponentDescriptor<?> descriptor, Object component, boolean success) {
        Set closeMethods = descriptor.getCloseMethods();
        for (CloseMethodDescriptor closeDescriptor : closeMethods) {
            if (!this._includeNonDistributedTasks && !closeDescriptor.isDistributed()) continue;
            if (success && closeDescriptor.isEnabledOnSuccess()) {
                closeDescriptor.close(component);
                continue;
            }
            if (!success && closeDescriptor.isEnabledOnFailure()) {
                closeDescriptor.close(component);
                continue;
            }
            logger.debug("Omitting close method {} since success={}", (Object)closeDescriptor, (Object)success);
        }
    }

    @Deprecated
    public void close(ComponentDescriptor<?> descriptor, Object component) {
        this.close(descriptor, component, true);
    }
}

