/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metadata;

import org.apache.metamodel.DataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreConnection;

public final class ForeignKey {
    private final String _foreignDatastoreName;
    private final String _foreignSchemaName;
    private final String _foreignTableName;
    private final String _foreignColumnName;

    public ForeignKey(String foreignDatastoreName, String foreignSchemaName, String foreignTableName, String foreignColumnName) {
        this._foreignDatastoreName = foreignDatastoreName;
        this._foreignSchemaName = foreignSchemaName;
        this._foreignTableName = foreignTableName;
        this._foreignColumnName = foreignColumnName;
    }

    public String getForeignColumnName() {
        return this._foreignColumnName;
    }

    public String getForeignDatastoreName() {
        return this._foreignDatastoreName;
    }

    public String getForeignSchemaName() {
        return this._foreignSchemaName;
    }

    public String getForeignTableName() {
        return this._foreignTableName;
    }

    public Column resolveForeignColumn(DatastoreCatalog datastoreCatalog) {
        Datastore datastore = datastoreCatalog.getDatastore(this.getForeignDatastoreName());
        if (datastore == null) {
            return null;
        }
        try (DatastoreConnection connection = datastore.openConnection();){
            Column column;
            DataContext dataContext = connection.getDataContext();
            Schema schema = dataContext.getSchemaByName(this.getForeignSchemaName());
            if (schema == null) {
                Column column2 = null;
                return column2;
            }
            Table table = schema.getTableByName(this.getForeignTableName());
            if (table == null) {
                Column column3 = null;
                return column3;
            }
            Column column4 = column = table.getColumnByName(this.getForeignColumnName());
            return column4;
        }
    }
}

