/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metadata;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.schema.Column;
import org.datacleaner.metadata.AbstractHasMetadataAnnotations;
import org.datacleaner.metadata.ColumnGroupMetadata;
import org.datacleaner.metadata.ColumnMetadata;
import org.datacleaner.metadata.MetadataAnnotation;
import org.datacleaner.metadata.TableMetadata;

public final class TableMetadataImpl
extends AbstractHasMetadataAnnotations
implements TableMetadata {
    private final String _tableName;
    private final ImmutableList<ColumnMetadata> _columnMetadata;
    private final ImmutableList<ColumnGroupMetadata> _columnGroupMetadata;

    public TableMetadataImpl(String tableName, Collection<? extends ColumnMetadata> columnMetadata, Collection<? extends ColumnGroupMetadata> columnGroupMetadata, Collection<? extends MetadataAnnotation> annotations) {
        super(annotations);
        this._tableName = tableName;
        this._columnMetadata = ImmutableList.copyOf(columnMetadata);
        this._columnGroupMetadata = ImmutableList.copyOf(columnGroupMetadata);
    }

    public String getName() {
        return this._tableName;
    }

    public ColumnMetadata getColumnMetadataByName(String columnName) {
        return this.getByName(columnName, this._columnMetadata);
    }

    public ColumnMetadata getColumnMetadata(Column column) {
        if (column == null) {
            return null;
        }
        String columnName = column.getName();
        return this.getColumnMetadataByName(columnName);
    }

    public List<ColumnMetadata> getColumnMetadata() {
        return this._columnMetadata;
    }

    public ColumnGroupMetadata getColumnGroupMetadataByName(String groupName) {
        return this.getByName(groupName, this._columnGroupMetadata);
    }

    public List<ColumnGroupMetadata> getColumnGroupMetadata() {
        return this._columnGroupMetadata;
    }
}

