/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.datacleaner.metamodel.datahub.DataHubCASMonitorHttpClient;
import org.datacleaner.metamodel.datahub.DataHubDefaultMonitorHttpClient;
import org.datacleaner.metamodel.datahub.DataHubSecurityMode;
import org.datacleaner.util.SecurityUtils;
import org.datacleaner.util.http.MonitorHttpClient;

public class DataHubConnection {
    public static final String CAS_PATH = "/cas";
    public static final String DEFAULT_SCHEMA = "MDM";
    private final String _hostname;
    private final int _port;
    private final boolean _useHTTPS;
    private final String _username;
    private final String _password;
    private final String _scheme;
    private boolean _acceptUnverifiedSslPeers;
    private final DataHubSecurityMode _securityMode;

    public DataHubConnection(String hostname, Integer port, String username, String password, boolean useHTTPS, boolean acceptUnverifiedSslPeers, DataHubSecurityMode dataHubSecurityMode) {
        this._hostname = hostname;
        this._port = port;
        this._useHTTPS = useHTTPS;
        this._username = username;
        this._password = password;
        this._scheme = this._useHTTPS ? "https" : "http";
        this._acceptUnverifiedSslPeers = acceptUnverifiedSslPeers;
        this._securityMode = dataHubSecurityMode;
    }

    public MonitorHttpClient getHttpClient(String contextUrl) {
        HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties();
        if (this._acceptUnverifiedSslPeers) {
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)SecurityUtils.createUnsafeSSLConnectionSocketFactory());
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        if (DataHubSecurityMode.CAS.equals((Object)this._securityMode)) {
            return new DataHubCASMonitorHttpClient(httpClient, this.getCasServerUrl(), this._username, this._password, contextUrl);
        }
        return new DataHubDefaultMonitorHttpClient(httpClient, this.getHostname(), this.getPort(), this._username, this._password);
    }

    public MonitorHttpClient getServiceClient(String contextUrl) {
        HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties();
        if (this._acceptUnverifiedSslPeers) {
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)SecurityUtils.createUnsafeSSLConnectionSocketFactory());
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        if (DataHubSecurityMode.CAS.equals((Object)this._securityMode)) {
            return new DataHubCASMonitorHttpClient(httpClient, this.getCasServerUrl(), this._username, this._password, contextUrl);
        }
        return new DataHubDefaultMonitorHttpClient(httpClient, this.getHostname(), this.getPort(), this._username, this._password);
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    private String getCasServerUrl() {
        URIBuilder uriBuilder = this.getBaseUrlBuilder();
        this.appendToPath(uriBuilder, CAS_PATH);
        try {
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
    }

    protected URIBuilder getBaseUrlBuilder() {
        URIBuilder baseUriBuilder = new URIBuilder();
        baseUriBuilder.setScheme(this._scheme);
        baseUriBuilder.setHost(this._hostname);
        if (this._useHTTPS && this._port != 443 || !this._useHTTPS && this._port != 80) {
            baseUriBuilder.setPort(this._port);
        }
        return baseUriBuilder;
    }

    private URIBuilder appendToPath(URIBuilder uriBuilder, String pathSegment) {
        if (uriBuilder.getPath() != null) {
            uriBuilder.setPath(uriBuilder.getPath() + pathSegment);
        }
        return uriBuilder.setPath(pathSegment);
    }
}

