/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.metamodel.AbstractDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Schema;
import org.datacleaner.metamodel.datahub.DataHubConnection;
import org.datacleaner.metamodel.datahub.DataHubConnectionHelper;
import org.datacleaner.metamodel.datahub.DataHubDataSet;
import org.datacleaner.metamodel.datahub.DataHubRepoConnection;
import org.datacleaner.metamodel.datahub.DataHubSchema;
import org.datacleaner.metamodel.datahub.DataHubUpdateCallback;
import org.datacleaner.metamodel.datahub.DataHubUpdateConnection;
import org.datacleaner.metamodel.datahub.update.SourceRecordIdentifier;
import org.datacleaner.metamodel.datahub.update.UpdateData;
import org.datacleaner.metamodel.datahub.utils.JsonSchemasResponseParser;
import org.datacleaner.metamodel.datahub.utils.JsonUpdateDataBuilder;
import org.datacleaner.util.http.MonitorHttpClient;

public class DataHubDataContext
extends AbstractDataContext
implements UpdateableDataContext {
    private static final String JSON_CONTENT_TYPE = ContentType.APPLICATION_JSON.getMimeType();
    private DataHubRepoConnection _repoConnection;
    private DataHubUpdateConnection _updateConnection;
    private Map<String, DataHubSchema> _schemas;
    private final String _tenantName;

    public DataHubDataContext(DataHubConnection connection) {
        this._repoConnection = new DataHubRepoConnection(connection);
        this._updateConnection = new DataHubUpdateConnection(connection);
        this._tenantName = this.retrieveTenantName();
        this._schemas = this.getDatahubSchemas();
    }

    private Map<String, DataHubSchema> getDatahubSchemas() {
        HashMap<String, DataHubSchema> schemas = new HashMap<String, DataHubSchema>();
        for (String datastoreName : this.getDataStoreNames()) {
            String uri = this._repoConnection.getSchemaUrl(this._tenantName, datastoreName);
            HttpGet request = new HttpGet(uri);
            HttpResponse response = this.executeRequest((HttpUriRequest)request, this._repoConnection.getHttpClient());
            HttpEntity entity = response.getEntity();
            JsonSchemasResponseParser parser = new JsonSchemasResponseParser();
            try {
                DataHubSchema schema = parser.parseJsonSchema(entity.getContent());
                schema.setDatastoreName(datastoreName);
                schemas.put(schema.getName(), schema);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return schemas;
    }

    public void executeUpdate(UpdateScript script) {
        try (DataHubUpdateCallback callback = new DataHubUpdateCallback(this);){
            script.run((UpdateCallback)callback);
        }
    }

    public DataSet executeQuery(Query query) {
        return new DataHubDataSet(this._tenantName, query, this._repoConnection);
    }

    private List<String> getDataStoreNames() {
        String uri = this._repoConnection.getDatastoreUrl(this._tenantName);
        HttpGet request = new HttpGet(uri);
        HttpResponse response = this.executeRequest((HttpUriRequest)request, this._repoConnection.getHttpClient());
        HttpEntity entity = response.getEntity();
        JsonSchemasResponseParser parser = new JsonSchemasResponseParser();
        try {
            return parser.parseDataStoreArray(entity.getContent());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Schema testGetMainSchema() {
        return this.getDefaultSchema();
    }

    private HttpResponse executeRequest(HttpUriRequest request, MonitorHttpClient httpClient) {
        HttpResponse response;
        try {
            response = httpClient.execute(request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        DataHubConnectionHelper.validateReponseStatusCode(response);
        return response;
    }

    protected String[] getSchemaNamesInternal() {
        return this._schemas.keySet().toArray(new String[this._schemas.size()]);
    }

    protected String getDefaultSchemaName() {
        return "MDM";
    }

    protected Schema getSchemaByNameInternal(String name) {
        return (Schema)this._schemas.get(name);
    }

    public void executeUpdates(List<UpdateData> pendingUpdates) {
        String uri = this._updateConnection.getGoldenRecordBatchUrl();
        HttpPut request = new HttpPut(uri);
        request.addHeader("Content-Type", JSON_CONTENT_TYPE);
        request.addHeader("Accept", JSON_CONTENT_TYPE);
        request.setEntity((HttpEntity)new StringEntity(JsonUpdateDataBuilder.buildJsonArray(pendingUpdates), ContentType.APPLICATION_JSON));
        this.executeRequest((HttpUriRequest)request, this._updateConnection.getHttpClient());
    }

    public void executeGoldenRecordDelete(List<String> pendingGoldenRecordDeletes) {
        String uri = this._updateConnection.getGoldenRecordBatchUrl();
        HttpPost request = new HttpPost(uri);
        request.addHeader("Content-Type", JSON_CONTENT_TYPE);
        request.addHeader("Accept", JSON_CONTENT_TYPE);
        request.setEntity((HttpEntity)new StringEntity(JsonUpdateDataBuilder.buildJsonArray(pendingGoldenRecordDeletes), ContentType.APPLICATION_JSON));
        this.executeRequest((HttpUriRequest)request, this._updateConnection.getHttpClient());
    }

    public void executeSourceDelete(List<SourceRecordIdentifier> pendingSourceDeletes) {
        String uri = this._updateConnection.getSourceRecordBatchUrl();
        HttpPost request = new HttpPost(uri);
        request.addHeader("Content-Type", JSON_CONTENT_TYPE);
        request.addHeader("Accept", JSON_CONTENT_TYPE);
        request.setEntity((HttpEntity)new StringEntity(JsonUpdateDataBuilder.buildJsonArray(pendingSourceDeletes), ContentType.APPLICATION_JSON));
        this.executeRequest((HttpUriRequest)request, this._updateConnection.getHttpClient());
    }

    /*
     * Exception decompiling
     */
    private String retrieveTenantName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class UserInfo {
        public String username;
        public String tenant;

        private UserInfo() {
        }
    }
}

