/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Table;
import org.datacleaner.metamodel.datahub.DataHubConnectionHelper;
import org.datacleaner.metamodel.datahub.DataHubRepoConnection;
import org.datacleaner.metamodel.datahub.DataHubSchema;
import org.datacleaner.metamodel.datahub.utils.JsonQueryDatasetResponseParser;
import org.datacleaner.util.http.MonitorHttpClient;

public class DataHubDataSet
extends AbstractDataSet {
    private static final int PAGE_SIZE = 10000;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String QUERY_PARAM = "q";
    private static final String FIRST_ROW_PARAM = "f";
    private static final String MAX_ROW_PARAM = "m";
    private final DataHubRepoConnection _connection;
    private final Query _query;
    private String _queryString;
    private String _uri;
    private boolean _paging;
    private Integer _nextPageFirstRow;
    private Integer _nextPageMaxRows;
    private Iterator<Object[]> _resultSetIterator;
    private Row _row;
    private boolean _endReached;

    public DataHubDataSet(String tenantName, Query query, DataHubRepoConnection connection) {
        super(DataHubDataSet.getSelectItems(query));
        Table table = ((FromItem)query.getFromClause().getItem(0)).getTable();
        this._queryString = this.getQueryString(query, table);
        this._query = query;
        this._connection = connection;
        this._uri = this.createEncodedUri(tenantName, table);
        this._paging = query.getMaxRows() == null;
        this._nextPageFirstRow = 1;
        this._nextPageMaxRows = 10000;
        this._endReached = false;
        this._resultSetIterator = this.getNextPage();
    }

    public Row getRow() {
        return this._row;
    }

    public boolean next() {
        if (!this._resultSetIterator.hasNext()) {
            if (this._paging && !this._endReached) {
                this._resultSetIterator = this.getNextPage();
                if (!this._resultSetIterator.hasNext()) {
                    this._row = null;
                    return false;
                }
            } else {
                this._row = null;
                return false;
            }
        }
        this._row = new DefaultRow(this.getHeader(), this._resultSetIterator.next());
        return true;
    }

    private Iterator<Object[]> getNextPage() {
        Integer firstRow = this._query.getFirstRow() == null ? this._nextPageFirstRow : this._query.getFirstRow();
        Integer maxRows = this._query.getMaxRows() == null ? this._nextPageMaxRows : this._query.getMaxRows();
        this._nextPageFirstRow = this._nextPageFirstRow + this._nextPageMaxRows;
        String uri = this._uri + this.createParams(firstRow, maxRows);
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", JSON_CONTENT_TYPE);
        HttpResponse response = this.executeRequest(request);
        List<Object[]> resultSet = this.getResultSet(response.getEntity());
        int resultSetSize = resultSet.size();
        this._endReached = resultSetSize < maxRows;
        return resultSet.iterator();
    }

    private List<Object[]> getResultSet(HttpEntity entity) {
        JsonQueryDatasetResponseParser parser = new JsonQueryDatasetResponseParser();
        try {
            List<Object[]> resultSet = parser.parseQueryResult(entity.getContent());
            return resultSet;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String createParams(Integer firstRow, Integer maxRows) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(QUERY_PARAM, this._queryString));
        params.add(new BasicNameValuePair(FIRST_ROW_PARAM, firstRow.toString()));
        params.add(new BasicNameValuePair(MAX_ROW_PARAM, maxRows.toString()));
        return URLEncodedUtils.format(params, (String)"utf-8");
    }

    private static List<SelectItem> getSelectItems(Query query) {
        return query.getSelectClause().getItems();
    }

    private String createEncodedUri(String tenantName, Table table) {
        String datastoreName = ((DataHubSchema)table.getSchema()).getDatastoreName();
        return this._connection.getQueryUrl(tenantName, datastoreName);
    }

    private String getQueryString(Query query, Table table) {
        String queryString = query.toSql();
        return queryString.replace(table.getName() + ".", "");
    }

    private HttpResponse executeRequest(HttpGet request) {
        HttpResponse response;
        MonitorHttpClient httpClient = this._connection.getHttpClient();
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        DataHubConnectionHelper.validateReponseStatusCode(response);
        return response;
    }
}

