/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Table;
import org.datacleaner.metamodel.datahub.DataHubUpdateCallback;

public class DataHubDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final String GR_ID_COLUMN_NAME = "gr_id";
    private static final String SOURCE_ID_COLUMN_NAME = "datasource_record_id";
    private static final String SOURCE_NAME_COLUMN_NAME = "datasource_name";
    private final DataHubUpdateCallback _callback;

    public DataHubDeleteBuilder(DataHubUpdateCallback callback, Table table) {
        super(table);
        this._callback = callback;
    }

    public void execute() throws MetaModelException {
        List whereItems = this.getWhereItems();
        if (whereItems == null || whereItems.size() == 0) {
            throw new IllegalArgumentException("Delete requires a condition.");
        }
        String firstColumnName = this.getConditionColumnName((FilterItem)whereItems.get(0));
        if (firstColumnName.equals(GR_ID_COLUMN_NAME)) {
            this.deleteGoldenRecord(whereItems);
        } else if (firstColumnName.equalsIgnoreCase(SOURCE_ID_COLUMN_NAME)) {
            this.deleteSourceRecord(whereItems);
        } else {
            throw new IllegalArgumentException("Delete condition is not valid.");
        }
    }

    private void deleteSourceRecord(List<FilterItem> whereItems) {
        if (whereItems.size() != 2) {
            throw new IllegalArgumentException("Delete must be executed on a SourceRecordsGoldenRecordFormat table using datasource_record_id and datasource_name as condition values.");
        }
        FilterItem firstWhereItem = whereItems.get(0);
        FilterItem secondWhereItem = whereItems.get(1);
        String secondColumnName = this.getConditionColumnName(secondWhereItem);
        if (!SOURCE_NAME_COLUMN_NAME.equals(secondColumnName)) {
            throw new IllegalArgumentException("Delete must be executed on a SourceRecordsGoldenRecordFormat table using datasource_record_id and datasource_name as condition values.");
        }
        String id = this.getConditionColumnValue(firstWhereItem);
        String sourceName = this.getConditionColumnValue(secondWhereItem);
        this._callback.executeDeleteSourceRecord(sourceName, id, this.getRecordType());
    }

    private void deleteGoldenRecord(List<FilterItem> whereItems) {
        if (whereItems.size() != 1) {
            throw new IllegalArgumentException("Delete requires the gr_id as the sole condition value.");
        }
        FilterItem whereItem = whereItems.get(0);
        String grId = this.getConditionColumnValue(whereItem);
        this._callback.executeDeleteGoldenRecord(grId);
    }

    private String getConditionColumnValue(FilterItem filterItem) {
        return (String)filterItem.getOperand();
    }

    private String getConditionColumnName(FilterItem filterItem) {
        return filterItem.getSelectItem().getColumn().getName();
    }

    private String getRecordType() {
        return this.getTable().getName();
    }
}

