/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import com.google.common.net.UrlEscapers;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.datacleaner.metamodel.datahub.DataHubConnection;
import org.datacleaner.util.http.MonitorHttpClient;

public class DataHubRepoConnection {
    private static final String DATASTORES_PATH = "/datastores";
    private static final String CONTEXT_PATH = "/datahub";
    private static final String REPOSITORY_PATH = "/api/dc-monitor";
    private static final String SCHEMA_EXTENSION = ".schemas";
    private static final String QUERY_EXTENSION = ".query?";
    private static final String USERINFO_PATH = "/_user";
    DataHubConnection _connection;

    public DataHubRepoConnection(DataHubConnection connection) {
        this._connection = connection;
    }

    public MonitorHttpClient getHttpClient() {
        return this._connection.getHttpClient(this.getContextUrl());
    }

    private String getContextUrl() {
        URIBuilder uriBuilder = this._connection.getBaseUrlBuilder();
        this.appendToPath(uriBuilder, CONTEXT_PATH);
        try {
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
    }

    public String getUserInfoUrl() {
        return this.getContextUrl() + REPOSITORY_PATH + USERINFO_PATH;
    }

    private URIBuilder appendToPath(URIBuilder uriBuilder, String pathSegment) {
        if (uriBuilder.getPath() != null) {
            uriBuilder.setPath(uriBuilder.getPath() + pathSegment);
        }
        return uriBuilder.setPath(pathSegment);
    }

    public String getSchemaUrl(String tenantName, String datastoreName) {
        String uri = this.getRepoUrlWithTenant(tenantName) + DATASTORES_PATH + "/" + UrlEscapers.urlPathSegmentEscaper().escape(datastoreName) + SCHEMA_EXTENSION;
        return uri;
    }

    public String getDatastoreUrl(String tenantName) {
        String uri = this.getRepoUrlWithTenant(tenantName) + DATASTORES_PATH;
        return uri;
    }

    public String getQueryUrl(String tenantName, String datastoreName) {
        return this.getRepoUrlWithTenant(tenantName) + DATASTORES_PATH + "/" + UrlEscapers.urlPathSegmentEscaper().escape(datastoreName) + QUERY_EXTENSION;
    }

    private String getRepoUrlWithTenant(String tenantName) {
        return this.getContextUrl() + REPOSITORY_PATH + "/" + UrlEscapers.urlPathSegmentEscaper().escape(tenantName);
    }

    public String getRepoUrl() {
        return this.getContextUrl() + REPOSITORY_PATH;
    }
}

