/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.util.HashMap;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.AbstractRowUpdationBuilder;
import org.datacleaner.metamodel.datahub.DataHubUpdateCallback;
import org.datacleaner.metamodel.datahub.update.UpdateData;

public class DataHubUpdateBuilder
extends AbstractRowUpdationBuilder {
    private final DataHubUpdateCallback _callback;

    public DataHubUpdateBuilder(DataHubUpdateCallback dataHubUpdateCallback, Table table) {
        super(table);
        this._callback = dataHubUpdateCallback;
    }

    public void execute() throws MetaModelException {
        UpdateData updateData = this.createUpdateData();
        this._callback.executeUpdate(updateData);
    }

    private UpdateData createUpdateData() {
        Object[] values = this.getValues();
        Column[] columns = this.getColumns();
        boolean[] explicitNulls = this.getExplicitNulls();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < columns.length; ++i) {
            Object value = values[i];
            if (value == null && !explicitNulls[i]) continue;
            String columnName = columns[i].getName();
            if (columnName.startsWith("_")) {
                throw new IllegalArgumentException("Updates are not allowed on fields containing meta data, identified by the prefix \" _\".");
            }
            fields.put(columnName, value);
        }
        List whereItems = this.getWhereItems();
        if (whereItems.size() != 1 || !"gr_id".equals(((FilterItem)whereItems.get(0)).getSelectItem().getColumn().getName())) {
            throw new IllegalArgumentException("Updates should have the gr_id as the sole condition value.");
        }
        String grId = (String)((FilterItem)whereItems.get(0)).getOperand();
        return new UpdateData(grId, fields);
    }
}

