/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;
import org.datacleaner.metamodel.datahub.DataHubDataContext;
import org.datacleaner.metamodel.datahub.DataHubDeleteBuilder;
import org.datacleaner.metamodel.datahub.DataHubUpdateBuilder;
import org.datacleaner.metamodel.datahub.update.SourceRecordIdentifier;
import org.datacleaner.metamodel.datahub.update.UpdateData;

public class DataHubUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback,
Closeable {
    public static final int INSERT_BATCH_SIZE = 100;
    public static final int DELETE_BATCH_SIZE = 100;
    private final DataHubDataContext _dataContext;
    private List<UpdateData> _pendingUpdates;
    private List<SourceRecordIdentifier> _pendingSourceDeletes;
    private List<String> _pendingGoldenRecordDeletes;

    public DataHubUpdateCallback(DataHubDataContext dataContext) {
        super((DataContext)dataContext);
        this._dataContext = dataContext;
        this._pendingUpdates = null;
        this._pendingSourceDeletes = null;
        this._pendingGoldenRecordDeletes = null;
    }

    public TableCreationBuilder createTable(Schema arg0, String arg1) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public TableDropBuilder dropTable(Table arg0) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isDropTableSupported() {
        return false;
    }

    public RowInsertionBuilder insertInto(Table arg0) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new DataHubDeleteBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return false;
    }

    public boolean isUpdateSupported() {
        return true;
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new DataHubUpdateBuilder(this, table);
    }

    public void executeUpdate(UpdateData updateData) {
        if (this._pendingUpdates == null) {
            this._pendingUpdates = new ArrayList<UpdateData>();
        }
        this._pendingUpdates.add(updateData);
        if (this._pendingUpdates.size() >= 100) {
            this.flushUpdates();
        }
    }

    public void executeDeleteGoldenRecord(String grId) {
        if (this._pendingGoldenRecordDeletes == null) {
            this._pendingGoldenRecordDeletes = new ArrayList<String>();
        }
        this._pendingGoldenRecordDeletes.add(grId);
        if (this._pendingGoldenRecordDeletes.size() >= 100) {
            this.flushGoldenRecordDeletes();
        }
    }

    public void executeDeleteSourceRecord(String source, String id, String recordType) {
        if (this._pendingSourceDeletes == null) {
            this._pendingSourceDeletes = new ArrayList<SourceRecordIdentifier>();
        }
        this._pendingSourceDeletes.add(new SourceRecordIdentifier(source, id, null, recordType));
        if (this._pendingSourceDeletes.size() >= 100) {
            this.flushSourceDeletes();
        }
    }

    @Override
    public void close() {
        this.flushUpdates();
        this.flushSourceDeletes();
        this.flushGoldenRecordDeletes();
    }

    private void flushUpdates() {
        if (this._pendingUpdates == null || this._pendingUpdates.isEmpty()) {
            return;
        }
        this._dataContext.executeUpdates(this._pendingUpdates);
        this._pendingUpdates = null;
    }

    private void flushSourceDeletes() {
        if (this._pendingSourceDeletes == null || this._pendingSourceDeletes.isEmpty()) {
            return;
        }
        this._dataContext.executeSourceDelete(this._pendingSourceDeletes);
        this._pendingSourceDeletes = null;
    }

    private void flushGoldenRecordDeletes() {
        if (this._pendingGoldenRecordDeletes == null || this._pendingGoldenRecordDeletes.isEmpty()) {
            return;
        }
        this._dataContext.executeGoldenRecordDelete(this._pendingGoldenRecordDeletes);
        this._pendingGoldenRecordDeletes = null;
    }
}

