/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.datacleaner.metamodel.datahub.DataHubConnection;
import org.datacleaner.util.http.MonitorHttpClient;

public class DataHubUpdateConnection {
    public static final String CONTEXT_PATH = "/datahub/api/v1";
    public static final String GOLDEN_RECORDS_PATH = "/goldenrecords/batch";
    public static final String SOURCE_RECORDS_PATH = "/sourcerecords/batch";
    private final DataHubConnection _connection;

    public DataHubUpdateConnection(DataHubConnection connection) {
        this._connection = connection;
    }

    public String getGoldenRecordBatchUrl() {
        return this.getContextUrl() + GOLDEN_RECORDS_PATH;
    }

    public String getSourceRecordBatchUrl() {
        return this.getContextUrl() + SOURCE_RECORDS_PATH;
    }

    public MonitorHttpClient getHttpClient() {
        return this._connection.getHttpClient(this.getContextUrl());
    }

    private String getContextUrl() {
        URIBuilder uriBuilder = this._connection.getBaseUrlBuilder();
        this.appendToPath(uriBuilder, CONTEXT_PATH);
        try {
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
    }

    private URIBuilder appendToPath(URIBuilder uriBuilder, String pathSegment) {
        if (uriBuilder.getPath() != null) {
            uriBuilder.setPath(uriBuilder.getPath() + pathSegment);
        }
        return uriBuilder.setPath(pathSegment);
    }
}

