/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class JsonQueryDatasetResponseParser {
    private boolean _parsingRows;
    private boolean _parsingRow;
    private ArrayList<Object> _currentRow;
    private String _currentFieldName;
    private int _arrayCount;

    public List<Object[]> parseQueryResult(InputStream inputStream) throws JsonParseException, IOException {
        this._parsingRows = false;
        this._parsingRow = false;
        this._arrayCount = 0;
        ArrayList<Object[]> queryResult = new ArrayList<Object[]>();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(inputStream);
        JsonToken token = parser.nextToken();
        while (token != null) {
            switch (parser.getCurrentToken()) {
                case FIELD_NAME: {
                    this._currentFieldName = parser.getText();
                    break;
                }
                case START_ARRAY: {
                    if (this._parsingRows) {
                        this._parsingRow = true;
                        this._currentRow = new ArrayList();
                        break;
                    }
                    if ("rows".equals(this._currentFieldName)) {
                        this._parsingRows = true;
                        break;
                    }
                    if (!this._parsingRows) break;
                    ++this._arrayCount;
                    break;
                }
                case END_ARRAY: {
                    if (this._arrayCount > 0) {
                        --this._arrayCount;
                        break;
                    }
                    if (this._parsingRow) {
                        this._parsingRow = false;
                        queryResult.add(this._currentRow.toArray(new Object[this._currentRow.size()]));
                        break;
                    }
                    if (!this._parsingRows) break;
                    this._parsingRows = false;
                    break;
                }
                case VALUE_STRING: {
                    if (!this._parsingRow) break;
                    this._currentRow.add(parser.getText());
                    break;
                }
                case VALUE_NULL: {
                    if (!this._parsingRow) break;
                    this._currentRow.add(null);
                    break;
                }
            }
            token = parser.nextToken();
        }
        return queryResult;
    }
}

