/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metamodel.datahub.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.datacleaner.metamodel.datahub.DataHubSchema;

public class JsonSchemasResponseParser {
    private static final Set<String> datastoreTypes = new HashSet<String>(Arrays.asList("GoldenRecordDatastore", "SourceRecordSourceFormatDatastore", "SourceRecordGoldenFormatDatastore"));
    private DatastoreObject _currentObject;
    private String _currentFieldname;
    private DataHubSchema _currentSchema;
    private MutableTable _currentTable;
    private MutableColumn _currentColumn;
    private DataHubSchema _resultSchema;
    private String _currentDataStoreName;
    private List<String> _dataStoreNames = new ArrayList<String>();

    public DataHubSchema parseJsonSchema(InputStream is) throws JsonParseException, IOException {
        this._currentObject = DatastoreObject.DATASTORE;
        this._currentFieldname = "";
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(is);
        JsonToken token = parser.nextToken();
        while (token != null) {
            switch (parser.getCurrentToken()) {
                case START_ARRAY: {
                    this._currentObject = this._currentObject.next();
                    break;
                }
                case END_ARRAY: {
                    this._currentObject = this._currentObject.previous();
                    break;
                }
                case START_OBJECT: {
                    this.createNewObject();
                    break;
                }
                case END_OBJECT: {
                    this.addObjectToSchema();
                    break;
                }
                case FIELD_NAME: {
                    this._currentFieldname = parser.getText();
                    break;
                }
                case VALUE_STRING: {
                    this.handleValue(this._currentFieldname, parser.getText());
                    break;
                }
                case VALUE_FALSE: {
                    this.handleBooleanValue(this._currentFieldname, false);
                    break;
                }
                case VALUE_TRUE: {
                    this.handleBooleanValue(this._currentFieldname, true);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    this.handleIntegerValue(this._currentFieldname, parser.getIntValue());
                }
            }
            token = parser.nextToken();
        }
        return this._resultSchema;
    }

    private void addObjectToSchema() {
        switch (this._currentObject) {
            case SCHEMA: {
                if ("INFORMATION_SCHEMA".equals(this._currentSchema.getName())) break;
                this._resultSchema = this._currentSchema;
                break;
            }
            case TABLE: {
                this._currentTable.setSchema((Schema)this._currentSchema);
                this._currentSchema.addTable(this._currentTable);
                break;
            }
            case COLUMN: {
                this._currentColumn.setTable((Table)this._currentTable);
                this._currentTable.addColumn((Column)this._currentColumn);
                break;
            }
        }
    }

    private void createNewObject() {
        switch (this._currentObject) {
            case SCHEMA: {
                this._currentSchema = new DataHubSchema();
            }
            case TABLE: {
                this._currentTable = new MutableTable();
                break;
            }
            case COLUMN: {
                this._currentColumn = new MutableColumn();
                break;
            }
        }
    }

    private void handleValue(String fieldName, String fieldValue) {
        switch (this._currentObject) {
            case SCHEMA: {
                this.handleSchemaField(fieldName, fieldValue);
                break;
            }
            case TABLE: {
                this.handleTableField(fieldName, fieldValue);
                break;
            }
            case COLUMN: {
                this.handleColumnField(fieldName, fieldValue);
                break;
            }
        }
    }

    private void handleBooleanValue(String fieldName, boolean fieldValue) {
        switch (this._currentObject) {
            case COLUMN: {
                this.handleBooleanColumnField(fieldName, fieldValue);
                break;
            }
        }
    }

    private void handleBooleanColumnField(String fieldName, boolean fieldValue) {
        if (fieldName.equals("primaryKey")) {
            this._currentColumn.setPrimaryKey(fieldValue);
        } else if (fieldName.equals("indexed")) {
            this._currentColumn.setIndexed(fieldValue);
        } else if (fieldName.equals("nullable")) {
            this._currentColumn.setNullable(Boolean.valueOf(fieldValue));
        }
    }

    private void handleIntegerValue(String fieldName, int fieldValue) {
        if (fieldName.equals("number")) {
            this._currentColumn.setColumnNumber(fieldValue);
        }
    }

    private void handleColumnField(String fieldName, String fieldValue) {
        if (fieldName.equals("name")) {
            this._currentColumn.setName(fieldValue);
        } else if (fieldName.equals("quote")) {
            this._currentColumn.setQuote(fieldValue);
        } else if (fieldName.equals("remarks")) {
            this._currentColumn.setRemarks(fieldValue);
        } else if (fieldName.equals("type")) {
            this._currentColumn.setType(ColumnTypeImpl.valueOf((String)fieldValue));
        } else if (fieldName.equals("nativeType")) {
            this._currentColumn.setNativeType(fieldValue);
        } else if (fieldName.equals("size")) {
            this._currentColumn.setColumnSize(new Integer(fieldValue));
        }
    }

    private void handleTableField(String fieldName, String fieldValue) {
        if (fieldName.equals("name")) {
            this._currentTable.setName(fieldValue);
        }
    }

    private void handleSchemaField(String fieldName, String fieldValue) {
        if (fieldName.equals("name")) {
            this._currentSchema.setName(fieldValue);
        }
    }

    private void handleDataStoreValue(String value) {
        if (this._currentFieldname.equals("name")) {
            this._currentDataStoreName = value;
        } else if (this._currentFieldname.equals("type") && datastoreTypes.contains(value)) {
            this._dataStoreNames.add(this._currentDataStoreName);
        }
    }

    public List<String> parseDataStoreArray(InputStream inputStream) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(inputStream);
        JsonToken token = parser.nextToken();
        while (token != null) {
            switch (parser.getCurrentToken()) {
                case FIELD_NAME: {
                    this._currentFieldname = parser.getText();
                    break;
                }
                case VALUE_STRING: {
                    this.handleDataStoreValue(parser.getText());
                    break;
                }
            }
            token = parser.nextToken();
        }
        return this._dataStoreNames;
    }

    private static enum DatastoreObject {
        DATASTORE{

            @Override
            public DatastoreObject previous() {
                return null;
            }
        }
        ,
        SCHEMA,
        TABLE,
        COLUMN{

            @Override
            public DatastoreObject next() {
                return null;
            }
        };


        public DatastoreObject next() {
            return DatastoreObject.values()[this.ordinal() + 1];
        }

        public DatastoreObject previous() {
            return DatastoreObject.values()[this.ordinal() - 1];
        }
    }
}

