/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.output.MetaModelOutputRow;
import org.datacleaner.output.OutputRow;
import org.datacleaner.output.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaModelOutputWriter
implements OutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaModelOutputWriter.class);
    private final UpdateableDataContext _dataContext;
    private final Queue<Object[]> _buffer;
    private final InputColumn<?>[] _columns;

    public AbstractMetaModelOutputWriter(UpdateableDataContext dataContext, InputColumn<?>[] columns, int bufferSize) {
        this._dataContext = dataContext;
        this._columns = columns;
        this._buffer = bufferSize > 0 ? new ArrayBlockingQueue<Object[]>(bufferSize) : new ConcurrentLinkedQueue<Object[]>();
    }

    @Override
    public final OutputRow createRow() {
        return new MetaModelOutputRow(this, this._columns);
    }

    protected final void addToBuffer(Object[] rowData) {
        while (!this._buffer.offer(rowData)) {
            this.flushBuffer();
        }
    }

    private final synchronized void flushBuffer() {
        if (!this._buffer.isEmpty()) {
            logger.info("Flushing {} rows in write buffer", (Object)this._buffer.size());
            this._dataContext.executeUpdate(new UpdateScript(){

                public void run(UpdateCallback callback) {
                    Object[] rowData = (Object[])AbstractMetaModelOutputWriter.this._buffer.poll();
                    while (rowData != null) {
                        RowInsertionBuilder insertBuilder = callback.insertInto(AbstractMetaModelOutputWriter.this.getTable());
                        for (int i = 0; i < AbstractMetaModelOutputWriter.this._columns.length; ++i) {
                            Object value = rowData[i];
                            insertBuilder = (RowInsertionBuilder)insertBuilder.value(i, value);
                        }
                        insertBuilder.execute();
                        rowData = (Object[])AbstractMetaModelOutputWriter.this._buffer.poll();
                    }
                }
            });
        }
    }

    protected abstract Table getTable();

    @Override
    public final void close() {
        this.flushBuffer();
        this.afterClose();
    }

    protected void afterClose() {
    }
}

