/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output.csv;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvWriter;
import org.apache.metamodel.util.Ref;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.output.OutputRow;

final class CsvOutputRow
implements OutputRow {
    private final Map<InputColumn<?>, Object> _map;
    private final InputColumn<?>[] _columns;
    private final Ref<OutputStream> _outputStreamRef;
    private final CsvConfiguration _csvConfiguration;

    public CsvOutputRow(Ref<OutputStream> outputStreamRef, CsvConfiguration csvConfiguration, InputColumn<?>[] columns) {
        this._outputStreamRef = outputStreamRef;
        this._csvConfiguration = csvConfiguration;
        this._columns = columns;
        this._map = new HashMap();
    }

    @Override
    public <E> OutputRow setValue(InputColumn<? super E> inputColumn, E value) {
        this._map.put(inputColumn, value);
        return this;
    }

    @Override
    public OutputRow setValues(InputRow row) {
        for (InputColumn<?> column : this._columns) {
            Object value = row.getValue(column);
            InputColumn<?> objectColumn = column;
            this.setValue(objectColumn, value);
        }
        return this;
    }

    @Override
    public void write() {
        String[] values = new String[this._columns.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = this._map.get(this._columns[i]);
            if (value == null) continue;
            values[i] = value.toString();
        }
        CsvWriter csvWriter = new CsvWriter(this._csvConfiguration);
        String line = csvWriter.buildLine(values);
        OutputStream outputStream = (OutputStream)this._outputStreamRef.get();
        try {
            byte[] bytes = line.getBytes(this._csvConfiguration.getEncoding());
            outputStream.write(bytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

