/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output.csv;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvWriter;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.Resource;
import org.datacleaner.api.InputColumn;
import org.datacleaner.output.OutputRow;
import org.datacleaner.output.OutputWriter;
import org.datacleaner.output.csv.CsvOutputRow;

final class CsvOutputWriter
implements OutputWriter {
    private final LazyRef<OutputStream> _outputStreamRef;
    private final InputColumn<?>[] _columns;
    private final CsvConfiguration _csvConfiguration;

    public CsvOutputWriter(final Resource resource, final CsvConfiguration csvConfiguration, final String[] columnNames, InputColumn<?>[] columns) {
        this._csvConfiguration = csvConfiguration;
        this._columns = columns;
        this._outputStreamRef = new LazyRef<OutputStream>(){

            protected OutputStream fetch() throws Throwable {
                OutputStream outputStream = resource.write();
                if (csvConfiguration.getColumnNameLineNumber() != 0) {
                    CsvWriter csvWriter = new CsvWriter(CsvOutputWriter.this._csvConfiguration);
                    String headerLine = csvWriter.buildLine(columnNames);
                    byte[] bytes = headerLine.getBytes(csvConfiguration.getEncoding());
                    outputStream.write(bytes);
                    outputStream.flush();
                }
                int bufferSize = 524288;
                return new BufferedOutputStream(outputStream, 524288);
            }
        };
    }

    @Override
    public OutputRow createRow() {
        return new CsvOutputRow((Ref<OutputStream>)this._outputStreamRef, this._csvConfiguration, this._columns);
    }

    @Override
    public void close() {
        if (this._outputStreamRef.isFetched()) {
            FileHelper.safeClose((Object[])new Object[]{this._outputStreamRef.get()});
        }
    }
}

