/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output.csv;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.api.InputColumn;
import org.datacleaner.output.OutputWriter;
import org.datacleaner.output.csv.CsvOutputWriter;

public final class CsvOutputWriterFactory {
    private static final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    private static final Map<String, CsvOutputWriter> outputWritersPerPath = new HashMap<String, CsvOutputWriter>();

    public static OutputWriter getWriter(String filename, List<InputColumn<?>> columns) {
        InputColumn[] columnArray = columns.toArray(new InputColumn[columns.size()]);
        String[] headers = new String[columnArray.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = columnArray[i].getName();
        }
        return CsvOutputWriterFactory.getWriter(filename, headers, ',', '\"', '\\', true, columnArray);
    }

    public static OutputWriter getWriter(String filename, String[] headers, char separatorChar, char quoteChar, char escapeChar, boolean includeHeader, InputColumn<?> ... columns) {
        return CsvOutputWriterFactory.getWriter((Resource)new FileResource(filename), headers, "UTF-8", separatorChar, quoteChar, escapeChar, includeHeader, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputWriter getWriter(Resource resource, String[] headers, String encoding, char separatorChar, char quoteChar, char escapeChar, boolean includeHeader, InputColumn<?> ... columns) {
        CsvOutputWriter outputWriter;
        CsvConfiguration csvConfiguration = CsvOutputWriterFactory.getConfiguration(encoding, separatorChar, quoteChar, escapeChar, includeHeader);
        String qualifiedPath = resource.getQualifiedPath();
        Map<String, CsvOutputWriter> map = outputWritersPerPath;
        synchronized (map) {
            outputWriter = outputWritersPerPath.get(qualifiedPath);
            if (outputWriter == null) {
                File file;
                File parentFile;
                if (resource instanceof FileResource && (parentFile = (file = ((FileResource)resource).getFile()).getParentFile()) != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                outputWritersPerPath.put(qualifiedPath, outputWriter);
                counters.put(qualifiedPath, new AtomicInteger(1));
                outputWriter = new CsvOutputWriter(resource, csvConfiguration, headers, columns);
            } else {
                outputWriter = new CsvOutputWriter(resource, csvConfiguration, headers, columns);
                counters.get(qualifiedPath).incrementAndGet();
            }
        }
        return outputWriter;
    }

    private static CsvConfiguration getConfiguration(String encoding, char separatorChar, char quoteChar, char escapeChar, boolean includeHeader) {
        int headerLine = includeHeader ? 1 : 0;
        return new CsvConfiguration(headerLine, encoding, separatorChar, quoteChar, escapeChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void release(String filename) {
        int count = counters.get(filename).decrementAndGet();
        if (count == 0) {
            Map<String, CsvOutputWriter> map = outputWritersPerPath;
            synchronized (map) {
                outputWritersPerPath.remove(filename);
            }
        }
    }
}

