/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Objects;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.job.NoSuchColumnException;
import org.datacleaner.job.NoSuchDatastoreException;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.DatastoreDictionaryConnection;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.DictionaryConnection;
import org.datacleaner.reference.SimpleDictionary;
import org.datacleaner.util.ReadObjectBuilder;

public final class DatastoreDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private final String _datastoreName;
    private final String _qualifiedColumnName;
    private final boolean _loadIntoMemory;

    public DatastoreDictionary(String name, String datastoreName, String qualifiedColumnName) {
        this(name, datastoreName, qualifiedColumnName, true);
    }

    public DatastoreDictionary(String name, String datastoreName, String qualifiedColumnName, boolean loadIntoMemory) {
        super(name);
        this._datastoreName = datastoreName;
        this._qualifiedColumnName = qualifiedColumnName;
        this._loadIntoMemory = loadIntoMemory;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, DatastoreDictionary.class).readObject(stream);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DatastoreDictionary other = (DatastoreDictionary)obj;
            return Objects.equals(this._datastoreName, other._datastoreName) && Objects.equals(this._qualifiedColumnName, other._qualifiedColumnName) && Objects.equals(this._loadIntoMemory, other._loadIntoMemory);
        }
        return false;
    }

    public SimpleDictionary loadIntoMemory(DatastoreConnection datastoreConnection) {
        DataContext dataContext = datastoreConnection.getDataContext();
        Column column = this.getColumn(datastoreConnection);
        Query query = dataContext.query().from(column.getTable()).select(column).toQuery();
        if (datastoreConnection.getDatastore().getPerformanceCharacteristics().isQueryOptimizationPreferred()) {
            query.getSelectClause().setDistinct(true);
        }
        HashSet<String> values = new HashSet<String>();
        try (DataSet dataSet = dataContext.executeQuery(query);){
            while (dataSet.next()) {
                Object value = dataSet.getRow().getValue(0);
                if (value == null) continue;
                values.add(value.toString());
            }
        }
        return new SimpleDictionary(this.getName(), values);
    }

    public DictionaryConnection openConnection(DataCleanerConfiguration configuration) {
        Datastore datastore = configuration.getDatastoreCatalog().getDatastore(this._datastoreName);
        if (datastore == null) {
            throw new NoSuchDatastoreException(this._datastoreName);
        }
        DatastoreConnection datastoreConnection = datastore.openConnection();
        if (this._loadIntoMemory) {
            SimpleDictionary simpleDictionary = this.loadIntoMemory(datastoreConnection);
            datastoreConnection.close();
            return simpleDictionary.openConnection(configuration);
        }
        return new DatastoreDictionaryConnection(this, datastoreConnection);
    }

    public Column getColumn(DatastoreConnection datastoreConnection) {
        try {
            Column column = datastoreConnection.getDataContext().getColumnByQualifiedLabel(this._qualifiedColumnName);
            if (column == null) {
                throw new NoSuchColumnException(this._qualifiedColumnName);
            }
            return column;
        }
        catch (RuntimeException e) {
            datastoreConnection.close();
            throw e;
        }
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public String getQualifiedColumnName() {
        return this._qualifiedColumnName;
    }

    public boolean isLoadIntoMemory() {
        return this._loadIntoMemory;
    }
}

