/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.schema.Column;
import org.datacleaner.components.convert.ConvertToStringTransformer;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.job.NoSuchColumnException;
import org.datacleaner.job.NoSuchDatastoreException;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.DatastoreSynonymCatalogConnection;
import org.datacleaner.reference.SimpleSynonymCatalog;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.SynonymCatalogConnection;

public final class DatastoreSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private final String _datastoreName;
    private final String _masterTermColumnPath;
    private final String[] _synonymColumnPaths;
    private final boolean _loadIntoMemory;

    public DatastoreSynonymCatalog(String name, String datastoreName, String masterTermColumnPath, String[] synonymColumnPaths) {
        this(name, datastoreName, masterTermColumnPath, synonymColumnPaths, true);
    }

    public DatastoreSynonymCatalog(String name, String datastoreName, String masterTermColumnPath, String[] synonymColumnPaths, boolean loadIntoMemory) {
        super(name);
        this._datastoreName = datastoreName;
        this._masterTermColumnPath = masterTermColumnPath;
        this._synonymColumnPaths = synonymColumnPaths;
        this._loadIntoMemory = loadIntoMemory;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DatastoreSynonymCatalog other = (DatastoreSynonymCatalog)obj;
            return Objects.equals(this._datastoreName, other._datastoreName) && Objects.equals(this._masterTermColumnPath, other._masterTermColumnPath) && Arrays.equals(this._synonymColumnPaths, other._synonymColumnPaths) && Objects.equals(this._loadIntoMemory, other._loadIntoMemory);
        }
        return false;
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public String getMasterTermColumnPath() {
        return this._masterTermColumnPath;
    }

    public String[] getSynonymColumnPaths() {
        return Arrays.copyOf(this._synonymColumnPaths, this._synonymColumnPaths.length);
    }

    public SynonymCatalogConnection openConnection(DataCleanerConfiguration configuration) {
        Datastore datastore = configuration.getDatastoreCatalog().getDatastore(this._datastoreName);
        if (datastore == null) {
            throw new NoSuchDatastoreException(this._datastoreName);
        }
        DatastoreConnection datastoreConnection = datastore.openConnection();
        if (this._loadIntoMemory) {
            SimpleSynonymCatalog simpleSynonymCatalog = this.loadIntoMemory(datastoreConnection);
            datastoreConnection.close();
            return simpleSynonymCatalog.openConnection(configuration);
        }
        return new DatastoreSynonymCatalogConnection(this, datastoreConnection);
    }

    public Column[] getSynonymColumns(DatastoreConnection datastoreConnection) {
        Column[] columns = new Column[this._synonymColumnPaths.length];
        for (int i = 0; i < columns.length; ++i) {
            String columnPath = this._synonymColumnPaths[i];
            columns[i] = datastoreConnection.getDataContext().getColumnByQualifiedLabel(columnPath);
            if (columns[i] != null) continue;
            throw new NoSuchColumnException(columnPath);
        }
        return columns;
    }

    public Column getMasterTermColumn(DatastoreConnection datastoreConnection) {
        DataContext dataContext = datastoreConnection.getDataContext();
        Column masterTermColumn = dataContext.getColumnByQualifiedLabel(this._masterTermColumnPath);
        if (masterTermColumn == null) {
            throw new NoSuchColumnException(this._masterTermColumnPath);
        }
        return masterTermColumn;
    }

    public SimpleSynonymCatalog loadIntoMemory(DatastoreConnection datastoreConnection) {
        HashMap<String, String> synonymMap = new HashMap<String, String>();
        Column masterTermColumn = this.getMasterTermColumn(datastoreConnection);
        Column[] columns = this.getSynonymColumns(datastoreConnection);
        try (DataSet dataSet = datastoreConnection.getDataContext().query().from(masterTermColumn.getTable().getName()).select(masterTermColumn).select(columns).execute();){
            while (dataSet.next()) {
                String[] synonyms;
                Row row = dataSet.getRow();
                String masterTerm = DatastoreSynonymCatalog.getMasterTerm(row, masterTermColumn);
                for (String synonym : synonyms = DatastoreSynonymCatalog.getSynonyms(row, columns)) {
                    synonymMap.put(synonym, masterTerm);
                }
            }
        }
        SimpleSynonymCatalog simpleSynonymCatalog = new SimpleSynonymCatalog(this.getName(), synonymMap);
        return simpleSynonymCatalog;
    }

    protected static String getMasterTerm(Row row, Column column) {
        Object value = row.getValue(column);
        return ConvertToStringTransformer.transformValue(value);
    }

    protected static String[] getSynonyms(Row row, Column[] columns) {
        ArrayList<String> synonyms = new ArrayList<String>();
        for (Column synonymColumn : columns) {
            Object value = row.getValue(synonymColumn);
            if (value == null) continue;
            String stringValue = value.toString();
            synonyms.add(stringValue);
        }
        return synonyms.toArray(new String[synonyms.size()]);
    }

    public boolean isLoadIntoMemory() {
        return this._loadIntoMemory;
    }
}

