/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.util.Collection;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.schema.Column;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.reference.DatastoreSynonymCatalog;
import org.datacleaner.reference.SimpleSynonymCatalog;
import org.datacleaner.reference.Synonym;
import org.datacleaner.reference.SynonymCatalogConnection;

final class DatastoreSynonymCatalogConnection
implements SynonymCatalogConnection {
    private final DatastoreConnection _datastoreConnection;
    private final DatastoreSynonymCatalog _synonymCatalog;

    public DatastoreSynonymCatalogConnection(DatastoreSynonymCatalog synonymCatalog, DatastoreConnection datastoreConnection) {
        this._synonymCatalog = synonymCatalog;
        this._datastoreConnection = datastoreConnection;
    }

    public Collection<Synonym> getSynonyms() {
        SimpleSynonymCatalog simpleSynonymCatalog = this._synonymCatalog.loadIntoMemory(this._datastoreConnection);
        return simpleSynonymCatalog.openConnection(null).getSynonyms();
    }

    public String getMasterTerm(String term) {
        DataContext dataContext = this._datastoreConnection.getDataContext();
        Column masterTermColumn = this._synonymCatalog.getMasterTermColumn(this._datastoreConnection);
        Column[] columns = this._synonymCatalog.getSynonymColumns(this._datastoreConnection);
        SatisfiedWhereBuilder queryBuilder = (SatisfiedWhereBuilder)dataContext.query().from(masterTermColumn.getTable()).select(masterTermColumn).where(columns[0]).eq(term);
        for (int i = 1; i < columns.length; ++i) {
            Column column = columns[i];
            queryBuilder = (SatisfiedWhereBuilder)queryBuilder.or(column).eq(term);
        }
        queryBuilder.maxRows(1);
        try (DataSet dataSet = queryBuilder.execute();){
            while (dataSet.next()) {
                Object value = dataSet.getRow().getValue(0);
                if (value == null) continue;
                String string = value.toString();
                return string;
            }
        }
        return null;
    }

    public SynonymCatalogConnection.Replacement replaceInline(String sentence) {
        SimpleSynonymCatalog simpleSynonymCatalog = this._synonymCatalog.loadIntoMemory(this._datastoreConnection);
        return simpleSynonymCatalog.openConnection(null).replaceInline(sentence);
    }

    public void close() {
        this._datastoreConnection.close();
    }
}

