/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.StringPatternConnection;
import org.datacleaner.util.ReadObjectBuilder;

public final class RegexStringPattern
extends AbstractReferenceData
implements StringPattern {
    private static final long serialVersionUID = 1L;
    private final String _expression;
    private final boolean _matchEntireString;

    public RegexStringPattern(String name, String expression, boolean matchEntireString) {
        super(name);
        this._expression = expression;
        this._matchEntireString = matchEntireString;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            RegexStringPattern other = (RegexStringPattern)obj;
            return Objects.equals(this._expression, other._expression) && Objects.equals(this._matchEntireString, other._matchEntireString);
        }
        return false;
    }

    public boolean isMatchEntireString() {
        return this._matchEntireString;
    }

    public String getExpression() {
        return this._expression;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, RegexStringPattern.class).readObject(stream);
    }

    @Override
    public String toString() {
        return "RegexStringPattern[name=" + this.getName() + ", expression=" + this._expression + ", matchEntireString=" + this._matchEntireString + "]";
    }

    public StringPatternConnection openConnection(DataCleanerConfiguration configuration) {
        return new StringPatternConnection(){
            private final Pattern _pattern;
            {
                this._pattern = Pattern.compile(RegexStringPattern.this._expression);
            }

            public boolean matches(String string) {
                if (string == null) {
                    return false;
                }
                Matcher matcher = this._pattern.matcher(string);
                if (matcher.find()) {
                    if (RegexStringPattern.this._matchEntireString) {
                        int e;
                        int s = matcher.start();
                        return s == 0 && (e = matcher.end()) == string.length();
                    }
                    return true;
                }
                return false;
            }

            public void close() {
            }
        };
    }
}

