/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.DictionaryConnection;
import org.datacleaner.reference.SimpleReferenceValues;
import org.datacleaner.util.ReadObjectBuilder;

public final class SimpleDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private final Set<String> _valueSet;
    private final boolean _caseSensitive;

    public SimpleDictionary(String name, String ... values) {
        this(name, true, values);
    }

    public SimpleDictionary(String name, boolean caseSensitive, String ... values) {
        this(name, SimpleDictionary.createValueSet(values, caseSensitive), caseSensitive);
    }

    public SimpleDictionary(String name, Collection<String> values) {
        this(name, values, false);
    }

    public SimpleDictionary(String name, Collection<String> values, boolean caseSensitive) {
        super(name);
        this._valueSet = caseSensitive ? Sets.newHashSet(values) : SimpleDictionary.createValueSet(values.iterator(), caseSensitive);
        this._caseSensitive = caseSensitive;
    }

    private static Set<String> createValueSet(Object[] array, boolean caseSensitive) {
        return SimpleDictionary.createValueSet(Iterators.forArray((Object[])array), caseSensitive);
    }

    private static Set<String> createValueSet(Iterator<?> iterator, boolean caseSensitive) {
        HashSet valueSet = Sets.newHashSet();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value == null) continue;
            if (caseSensitive) {
                valueSet.add(value.toString());
                continue;
            }
            valueSet.add(value.toString().toLowerCase());
        }
        return valueSet;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.Adaptor adaptor = new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws Exception {
                boolean caseSensitive = getField.get("_caseSensitive", true);
                Field caseSensitiveField = SimpleDictionary.class.getDeclaredField("_caseSensitive");
                caseSensitiveField.setAccessible(true);
                caseSensitiveField.set(serializable, caseSensitive);
                try {
                    Object oldValues = getField.get("_values", null);
                    if (oldValues != null) {
                        SimpleReferenceValues srv = (SimpleReferenceValues)oldValues;
                        Object[] values = srv.getValues();
                        Set valueSet = SimpleDictionary.createValueSet(values, caseSensitive);
                        Field valuesField = SimpleDictionary.class.getDeclaredField("_valueSet");
                        valuesField.setAccessible(true);
                        valuesField.set(serializable, valueSet);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        ReadObjectBuilder.create(this, SimpleDictionary.class).readObject(stream, adaptor);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SimpleDictionary other = (SimpleDictionary)obj;
            return Objects.equals(this._valueSet, other._valueSet) && Objects.equals(this._caseSensitive, other._caseSensitive);
        }
        return false;
    }

    public DictionaryConnection openConnection(DataCleanerConfiguration configuration) {
        return new DictionaryConnection(){

            public Iterator<String> getAllValues() {
                return SimpleDictionary.this._valueSet.iterator();
            }

            public Iterator<String> getLengthSortedValues() {
                TreeSet<String> connectionValueSet = new TreeSet<String>(Comparator.comparingInt(String::length).reversed().thenComparing(String::compareTo));
                connectionValueSet.addAll(SimpleDictionary.this._valueSet);
                return connectionValueSet.iterator();
            }

            public boolean containsValue(String value) {
                if (value == null) {
                    return false;
                }
                if (!SimpleDictionary.this._caseSensitive) {
                    value = value.toLowerCase();
                }
                return SimpleDictionary.this._valueSet.contains(value);
            }

            public void close() {
            }
        };
    }

    public Set<String> getValueSet() {
        return this._valueSet;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }
}

