/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.MutableSynonym;
import org.datacleaner.reference.Synonym;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.SynonymCatalogConnection;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.StringUtils;

public final class SimpleSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> _synonymMap;
    private final boolean _caseSensitive;

    public SimpleSynonymCatalog(String name) {
        this(name, new HashMap<String, String>());
    }

    public SimpleSynonymCatalog(String name, Map<String, String> synonyms) {
        this(name, synonyms, true);
    }

    public SimpleSynonymCatalog(String name, Map<String, String> synonyms, boolean caseSensitive) {
        super(name);
        this._caseSensitive = caseSensitive;
        this._synonymMap = synonyms;
    }

    private Map<String, String> createSingleWordSynonymMap() {
        if (this._caseSensitive) {
            return this._synonymMap;
        }
        HashMap<String, String> synonymMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entries = this._synonymMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String synonym = entry.getKey();
            String masterTerm = entry.getValue();
            if (!StringUtils.isSingleWord(synonym)) continue;
            synonymMap.put(synonym.toLowerCase(), masterTerm);
        }
        return synonymMap;
    }

    private SortedMap<String, String> createMultiWordSynonymMap() {
        TreeMap<String, String> synonymMap = new TreeMap<String, String>(Comparator.comparingInt(String::length).reversed().thenComparing(String::compareTo));
        Set<Map.Entry<String, String>> entries = this._synonymMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String synonym = entry.getKey();
            String masterTerm = entry.getValue();
            if (StringUtils.isSingleWord(synonym)) continue;
            if (this._caseSensitive) {
                synonymMap.put(synonym, masterTerm);
                continue;
            }
            synonymMap.put(synonym.toLowerCase(), masterTerm);
        }
        return synonymMap;
    }

    public SimpleSynonymCatalog(String name, Synonym ... synonyms) {
        this(name);
        for (Synonym synonym : synonyms) {
            this.addSynonym(synonym);
        }
    }

    public SimpleSynonymCatalog(String name, List<Synonym> synonyms) {
        this(name);
        for (Synonym synonym : synonyms) {
            this.addSynonym(synonym);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.Adaptor adaptor = new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws Exception {
                boolean caseSensitive = getField.get("_caseSensitive", true);
                Field field = SimpleSynonymCatalog.class.getDeclaredField("_caseSensitive");
                field.setAccessible(true);
                field.set(serializable, caseSensitive);
            }
        };
        ReadObjectBuilder.create(this, SimpleSynonymCatalog.class).readObject(stream, adaptor);
    }

    private void addSynonym(Synonym synonym) {
        String masterTerm = synonym.getMasterTerm();
        String key = this._caseSensitive ? masterTerm : masterTerm.toLowerCase();
        this._synonymMap.put(key, masterTerm);
        Collection values = synonym.getSynonyms();
        for (String value : values) {
            String key2 = this._caseSensitive ? value : value.toLowerCase();
            this._synonymMap.put(key2, masterTerm);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SimpleSynonymCatalog other = (SimpleSynonymCatalog)obj;
            return Objects.equals(this._synonymMap, other._synonymMap) && Objects.equals(this._caseSensitive, other._caseSensitive);
        }
        return false;
    }

    public SynonymCatalogConnection openConnection(DataCleanerConfiguration configuration) {
        return new SynonymCatalogConnection(){
            private final SortedMap<String, String> _sortedMultiWordSynonymMap;
            private final Map<String, String> _singleWordSynonymMap;
            {
                this._sortedMultiWordSynonymMap = SimpleSynonymCatalog.this.createMultiWordSynonymMap();
                this._singleWordSynonymMap = SimpleSynonymCatalog.this.createSingleWordSynonymMap();
            }

            public Collection<Synonym> getSynonyms() {
                TreeMap<String, MutableSynonym> synonyms = new TreeMap<String, MutableSynonym>();
                for (Map.Entry synonymEntry : SimpleSynonymCatalog.this._synonymMap.entrySet()) {
                    String masterTerm = (String)synonymEntry.getValue();
                    String synonymValue = (String)synonymEntry.getKey();
                    MutableSynonym synonym = (MutableSynonym)synonyms.get(masterTerm);
                    if (synonym == null) {
                        synonym = new MutableSynonym(masterTerm);
                        synonyms.put(masterTerm, synonym);
                    }
                    synonym.addSynonym(synonymValue);
                }
                return synonyms.values();
            }

            public String getMasterTerm(String term) {
                if (term == null) {
                    return null;
                }
                String key = SimpleSynonymCatalog.this._caseSensitive ? term : term.toLowerCase();
                return this._singleWordSynonymMap.get(key);
            }

            public SynonymCatalogConnection.Replacement replaceInline(String sentence) {
                final ArrayList<Object> synonyms = new ArrayList<Object>();
                final ArrayList<String> masterTerms = new ArrayList<String>();
                String matchString = !SimpleSynonymCatalog.this._caseSensitive ? sentence.toLowerCase() : sentence;
                Set<Map.Entry<String, String>> entries = this._sortedMultiWordSynonymMap.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    String synonym = entry.getKey();
                    String masterTerm = entry.getValue();
                    Matcher matcher = Pattern.compile("\\b" + (String)synonym + "\\b").matcher(matchString);
                    while (matcher.find()) {
                        sentence = sentence.substring(0, matcher.start()) + masterTerm + sentence.substring(matcher.end());
                        matchString = SimpleSynonymCatalog.this._caseSensitive ? sentence.toLowerCase() : sentence;
                        synonyms.add(synonym);
                        masterTerms.add(masterTerm);
                    }
                }
                StringBuilder sb = new StringBuilder();
                List<String> tokens = StringUtils.splitOnWordBoundaries(sentence, true);
                for (String token : tokens) {
                    if (StringUtils.isSingleWord(token)) {
                        String masterTerm = this.getMasterTerm(token);
                        if (masterTerm == null) {
                            sb.append(token);
                            continue;
                        }
                        if (!masterTerm.equals(token)) {
                            synonyms.add(token);
                            masterTerms.add(masterTerm);
                        }
                        sb.append(masterTerm);
                        continue;
                    }
                    sb.append(token);
                }
                final String finalSentence = sb.toString();
                return new SynonymCatalogConnection.Replacement(){

                    public String getReplacedString() {
                        return finalSentence;
                    }

                    public List<String> getSynonyms() {
                        return synonyms;
                    }

                    public List<String> getMasterTerms() {
                        return masterTerms;
                    }
                };
            }

            public void close() {
            }
        };
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public Map<String, String> getSynonymMap() {
        return this._synonymMap;
    }
}

