/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.DictionaryConnection;
import org.datacleaner.reference.SimpleDictionary;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.convert.ResourceConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextFileDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TextFileDictionary.class);
    private final String _filename;
    private final String _encoding;
    private final boolean _caseSensitive;

    public TextFileDictionary(String name, String filename, String encoding) {
        this(name, filename, encoding, true);
    }

    public TextFileDictionary(String name, String filename, String encoding, boolean caseSensitive) {
        super(name);
        this._filename = filename;
        this._encoding = encoding;
        this._caseSensitive = caseSensitive;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.Adaptor adaptor = new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws Exception {
                boolean caseSensitive = getField.get("_caseSensitive", true);
                Field field = TextFileDictionary.class.getDeclaredField("_caseSensitive");
                field.setAccessible(true);
                field.set(serializable, caseSensitive);
            }
        };
        ReadObjectBuilder.create(this, TextFileDictionary.class).readObject(stream, adaptor);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            TextFileDictionary other = (TextFileDictionary)obj;
            return Objects.equals(this._filename, other._filename) && Objects.equals(this._encoding, other._encoding) && Objects.equals(this._caseSensitive, other._caseSensitive);
        }
        return false;
    }

    public DictionaryConnection openConnection(DataCleanerConfiguration configuration) {
        ResourceConverter rc = new ResourceConverter(configuration);
        final Resource resource = rc.fromString(Resource.class, this._filename);
        Set values = (Set)resource.read((Func)new Func<InputStream, Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<String> eval(InputStream in) {
                HashSet<String> values = new HashSet<String>();
                BufferedReader reader = FileHelper.getBufferedReader((InputStream)in, (String)TextFileDictionary.this.getEncoding());
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        if (!TextFileDictionary.this._caseSensitive) {
                            line = line.toLowerCase();
                        }
                        values.add(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    try {
                        logger.error("Failed to read line from resource: {}", (Object)resource, (Object)e);
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{reader});
                        throw throwable;
                    }
                    FileHelper.safeClose((Object[])new Object[]{reader});
                }
                FileHelper.safeClose((Object[])new Object[]{reader});
                return values;
            }
        });
        SimpleDictionary simpleDictionary = new SimpleDictionary(this.getName(), values, this._caseSensitive);
        return simpleDictionary.openConnection(configuration);
    }

    @Override
    public String toString() {
        return "TextFileDictionary[name=" + this.getName() + ", filename=" + this._filename + ", encoding=" + this._encoding + "]";
    }

    public String getFilename() {
        return this._filename;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }
}

