/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import au.com.bytecode.opencsv.CSVParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.SimpleSynonymCatalog;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.SynonymCatalogConnection;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.convert.ResourceConverter;

public final class TextFileSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private final String _filename;
    private final boolean _caseSensitive;
    private final String _encoding;

    public TextFileSynonymCatalog(String name, File file, boolean caseSensitive, String encoding) {
        this(name, file.getPath(), caseSensitive, encoding);
    }

    public TextFileSynonymCatalog(String name, String filename, boolean caseSensitive, String encoding) {
        super(name);
        this._filename = filename;
        this._caseSensitive = caseSensitive;
        this._encoding = encoding;
    }

    public SynonymCatalogConnection openConnection(DataCleanerConfiguration configuration) {
        ResourceConverter rc = new ResourceConverter(configuration);
        Resource resource = rc.fromString(Resource.class, this._filename);
        Map synonyms = (Map)resource.read((Func)new Func<InputStream, Map<String, String>>(){

            public Map<String, String> eval(InputStream in) {
                HashMap<String, String> synonyms = new HashMap<String, String>();
                CSVParser parser = new CSVParser(',', '\"', '\\');
                BufferedReader reader = FileHelper.getBufferedReader((InputStream)in, (String)TextFileSynonymCatalog.this._encoding);
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String[] values;
                        line = line.trim();
                        try {
                            values = parser.parseLine(line);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Failed to parse line: " + line, e);
                        }
                        if (values.length > 0) {
                            synonyms.put(values[0], values[0]);
                        }
                        if (values.length > 1) {
                            for (int i = 1; i < values.length; ++i) {
                                synonyms.put(values[i], values[0]);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    try {
                        throw new IllegalStateException(e);
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{reader});
                        throw throwable;
                    }
                }
                FileHelper.safeClose((Object[])new Object[]{reader});
                return synonyms;
            }
        });
        return new SimpleSynonymCatalog(this.getName(), synonyms, this._caseSensitive).openConnection(configuration);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, TextFileSynonymCatalog.class).readObject(stream);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            TextFileSynonymCatalog other = (TextFileSynonymCatalog)obj;
            return Objects.equals(this._filename, other._filename) && Objects.equals(this._caseSensitive, other._caseSensitive) && Objects.equals(this._encoding, other._encoding);
        }
        return false;
    }

    @Override
    public String toString() {
        return "TextFileSynonymCatalog[name=" + this.getName() + ", filename=" + this._filename + ", caseSensitive=" + this._caseSensitive + ", encoding=" + this._encoding + "]";
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getFilename() {
        return this._filename;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }
}

