/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository.file;

import java.io.File;
import org.datacleaner.repository.Repository;
import org.datacleaner.repository.RepositoryFile;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.repository.RepositoryNode;
import org.datacleaner.repository.file.FileRepositoryFolder;

public class FileRepository
extends FileRepositoryFolder
implements Repository {
    private static final long serialVersionUID = 1L;

    public FileRepository(String filename) {
        this(new File(filename));
    }

    public FileRepository(File file) {
        super(null, file);
    }

    @Override
    public RepositoryFolder getParent() {
        return null;
    }

    @Override
    public String getName() {
        return "";
    }

    public RepositoryNode getRepositoryNode(String path) {
        FileRepository folder = this;
        String[] pathParts = path.split("/");
        for (int i = 0; i < pathParts.length - 1; ++i) {
            String pathPart = pathParts[i];
            if (pathPart.isEmpty() || (folder = folder.getFolder(pathPart)) != null) continue;
            return null;
        }
        String lastPart = pathParts[pathParts.length - 1];
        if (lastPart.isEmpty()) {
            return folder;
        }
        RepositoryFile file = folder.getFile(lastPart);
        if (file == null) {
            return folder.getFolder(lastPart);
        }
        return file;
    }
}

