/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.datacleaner.repository.AbstractRepositoryNode;
import org.datacleaner.repository.RepositoryFile;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.repository.file.FileRepositoryFolder;
import org.datacleaner.util.FileFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileRepositoryFile
extends AbstractRepositoryNode
implements RepositoryFile {
    private static final Logger logger = LoggerFactory.getLogger(FileRepositoryFile.class);
    private static final long serialVersionUID = 1L;
    private final ReadWriteLock _lock;
    private final FileRepositoryFolder _parent;
    private final File _file;

    public FileRepositoryFile(FileRepositoryFolder parent, File file) {
        this._parent = parent;
        this._file = file;
        this._lock = new ReentrantReadWriteLock();
    }

    public File getFile() {
        return this._file;
    }

    public RepositoryFolder getParent() {
        return this._parent;
    }

    public String getName() {
        return this._file.getName();
    }

    public long getSize() {
        return this._file.length();
    }

    @Deprecated
    public InputStream readFile() {
        try {
            FileInputStream in = new FileInputStream(this._file);
            BufferedInputStream bin = new BufferedInputStream(in);
            return bin;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(Action<InputStream> readCallback) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            BufferedInputStream inputStream;
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this._file);
                inputStream = new BufferedInputStream(fileInputStream);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            try {
                readCallback.run((Object)inputStream);
            }
            catch (Exception e) {
                try {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException("Error occurred while reading from file", e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream, fileInputStream});
                    throw throwable;
                }
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream, fileInputStream});
        }
        finally {
            readLock.unlock();
        }
    }

    public <E> E readFile(Func<InputStream, E> readCallback) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            Object object;
            BufferedInputStream inputStream;
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this._file);
                inputStream = new BufferedInputStream(fileInputStream);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            try {
                Object result;
                object = result = readCallback.eval((Object)inputStream);
            }
            catch (Exception e) {
                try {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException("Error occurred while writing to file", e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream, fileInputStream});
                    throw throwable;
                }
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream, fileInputStream});
            return (E)object;
        }
        finally {
            readLock.unlock();
        }
    }

    public OutputStream writeFile(boolean append) {
        try {
            return new FileOutputStream(this._file, append);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeFile(Action<OutputStream> writeCallback) {
        this.writeFile(writeCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Action<OutputStream> writeCallback, boolean append) {
        Lock writeLock = this._lock.writeLock();
        writeLock.lock();
        try {
            BufferedOutputStream outputStream;
            FileOutputStream fileOutputStream;
            block10: {
                try {
                    fileOutputStream = new FileOutputStream(this._file, append);
                    outputStream = new BufferedOutputStream(fileOutputStream);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    if (writeCallback == null) break block10;
                    writeCallback.run((Object)outputStream);
                }
                catch (Exception e) {
                    try {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new IllegalStateException("Error occurred while writing to file", e);
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{outputStream, fileOutputStream});
                        throw throwable;
                    }
                }
            }
            FileHelper.safeClose((Object[])new Object[]{outputStream, fileOutputStream});
        }
        finally {
            writeLock.unlock();
        }
    }

    public RepositoryFile.Type getType() {
        if (this.getName().endsWith(FileFilters.ANALYSIS_XML.getExtension())) {
            return RepositoryFile.Type.ANALYSIS_JOB;
        }
        if (this.getName().endsWith(FileFilters.ANALYSIS_RESULT_SER.getExtension())) {
            return RepositoryFile.Type.ANALYSIS_RESULT;
        }
        if (this.getName().endsWith(FileFilters.ANALYSIS_TIMELINE_XML.getExtension())) {
            return RepositoryFile.Type.TIMELINE_SPEC;
        }
        return RepositoryFile.Type.OTHER;
    }

    public void delete() throws IllegalStateException {
        boolean success = this._file.delete();
        if (!success) {
            throw new IllegalStateException("Could not delete file: " + this._file);
        }
        this._parent.onDeleted(this._file);
    }

    public long getLastModified() {
        long lastModified = this._file.lastModified();
        if (lastModified == 0L) {
            if (logger.isWarnEnabled()) {
                logger.warn("File.lastModified() return 0. File.exists()={}, File.getPath()={}", (Object)this._file.exists(), (Object)this._file.getPath());
            }
            return -1L;
        }
        return lastModified;
    }

    public Resource toResource() {
        return new FileResource(this._file);
    }
}

