/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository.file;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.ToStringComparator;
import org.datacleaner.repository.AbstractRepositoryNode;
import org.datacleaner.repository.RepositoryFile;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.repository.RepositoryNode;
import org.datacleaner.repository.file.FileRepositoryFile;
import org.datacleaner.repository.file.LatestFileFilter;

public class FileRepositoryFolder
extends AbstractRepositoryNode
implements RepositoryFolder {
    private static final long serialVersionUID = 1L;
    private final File _file;
    private final FileRepositoryFolder _parent;
    private transient LoadingCache<File, RepositoryNode> _childCache;

    public FileRepositoryFolder(FileRepositoryFolder parent, File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        this._parent = parent;
        this._file = file;
    }

    private LoadingCache<File, RepositoryNode> getChildCache() {
        if (this._childCache == null) {
            this._childCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<File, RepositoryNode>(){

                public RepositoryNode load(File key) throws Exception {
                    if (key.isDirectory()) {
                        return new FileRepositoryFolder(FileRepositoryFolder.this, key);
                    }
                    return new FileRepositoryFile(FileRepositoryFolder.this, key);
                }
            });
        }
        return this._childCache;
    }

    public File getFile() {
        return this._file;
    }

    public RepositoryFolder getParent() {
        return this._parent;
    }

    public String getName() {
        return this._file.getName();
    }

    public List<RepositoryFolder> getFolders() {
        Object[] directories = this._file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.isHidden() && !file.getName().startsWith(".");
            }
        });
        Arrays.sort(directories);
        return CollectionUtils.map((Object[])directories, (Func)new Func<File, RepositoryFolder>(){

            public RepositoryFolder eval(File directory) {
                return (RepositoryFolder)FileRepositoryFolder.this.getChildCache().getUnchecked((Object)directory);
            }
        });
    }

    public RepositoryFile getLatestFile(String prefix, String extension) {
        FileFilter baseFilter = this.createFileFilter(prefix, extension);
        LatestFileFilter latestFileFilter = new LatestFileFilter(baseFilter);
        this._file.listFiles(latestFileFilter);
        File latestFile = latestFileFilter.getLatestFile();
        if (latestFile == null) {
            return null;
        }
        return (RepositoryFile)this.getChildCache().getUnchecked((Object)latestFile);
    }

    public List<RepositoryFile> getFiles(String prefix, String extension) {
        Object[] files = this._file.listFiles(this.createFileFilter(prefix, extension));
        Arrays.sort(files, ToStringComparator.getComparator());
        return CollectionUtils.map((Object[])files, (Func)new Func<File, RepositoryFile>(){

            public RepositoryFile eval(File file) {
                return (RepositoryFile)FileRepositoryFolder.this.getChildCache().getUnchecked((Object)file);
            }
        });
    }

    private FileFilter createFileFilter(final String prefix, final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile() && !file.isHidden()) {
                    String filename = file.getName();
                    if (prefix == null || filename.startsWith(prefix)) {
                        if (extension == null) {
                            return true;
                        }
                        return filename.endsWith(extension);
                    }
                }
                return false;
            }
        };
    }

    public List<RepositoryFile> getFiles() {
        return this.getFiles(null, null);
    }

    public RepositoryFile getFile(String name) {
        if (name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            throw new IllegalArgumentException("File name cannot contain slashes");
        }
        File file = new File(this._file, name);
        if (!file.exists()) {
            return null;
        }
        if (file.isHidden()) {
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        return (RepositoryFile)this.getChildCache().getUnchecked((Object)file);
    }

    public RepositoryFolder getFolder(String name) {
        if (name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            throw new IllegalArgumentException("Folder name cannot contain slashes");
        }
        File file = new File(this._file, name);
        if (!file.exists() || file.isHidden() || !file.isDirectory()) {
            return null;
        }
        return (RepositoryFolder)this.getChildCache().getUnchecked((Object)file);
    }

    public RepositoryFile createFile(String name, Action<OutputStream> writeCallback) {
        if (name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            throw new IllegalArgumentException("File name cannot contain slashes");
        }
        File file = new File(this._file, name);
        if (file.exists()) {
            throw new IllegalArgumentException("A file with the name '" + name + "' already exists");
        }
        RepositoryFile repositoryFile = (RepositoryFile)this.getChildCache().getUnchecked((Object)file);
        repositoryFile.writeFile(writeCallback);
        return repositoryFile;
    }

    public void delete() throws IllegalStateException {
        boolean success = this._file.delete();
        if (!success) {
            throw new IllegalStateException("Could not delete directory: " + this._file);
        }
        this._parent.onDeleted(this._file);
    }

    protected void onDeleted(File file) {
        this.getChildCache().invalidate((Object)file);
    }

    public RepositoryFolder createFolder(String name) {
        File file = new File(this._file, name);
        if (file.exists()) {
            throw new IllegalArgumentException("Folder with name '" + name + "' already exists");
        }
        boolean result = file.mkdir();
        if (!result) {
            throw new IllegalStateException("Failed to create directory '" + name + "' within " + this._file);
        }
        return (RepositoryFolder)this.getChildCache().getUnchecked((Object)file);
    }

    public RepositoryFolder getOrCreateFolder(String name) {
        File file = new File(this._file, name);
        if (!file.exists()) {
            file.mkdir();
        }
        return (RepositoryFolder)this.getChildCache().getUnchecked((Object)file);
    }
}

