/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository.file;

import java.io.File;
import java.io.FileFilter;

public class LatestFileFilter
implements FileFilter {
    private final FileFilter _delegate;
    private File _candidate;
    private long _latestModified;

    public LatestFileFilter(FileFilter delegate) {
        this._delegate = delegate;
        this._latestModified = Long.MIN_VALUE;
    }

    @Override
    public boolean accept(File candidate) {
        if (candidate.lastModified() > this._latestModified && this._delegate.accept(candidate)) {
            this._latestModified = candidate.lastModified();
            this._candidate = candidate;
        }
        return false;
    }

    public File getLatestFile() {
        return this._candidate;
    }
}

