/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.AnalyzerJobHelper;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.result.AnalysisResult;
import org.datacleaner.util.ReflectionUtils;

public abstract class AbstractAnalysisResult
implements AnalysisResult {
    @Override
    public <R extends AnalyzerResult> List<? extends R> getResults(Class<R> resultClass) {
        ArrayList<AnalyzerResult> list = new ArrayList<AnalyzerResult>();
        List<AnalyzerResult> results = this.getResults();
        for (AnalyzerResult analyzerResult : results) {
            if (!ReflectionUtils.is(analyzerResult.getClass(), resultClass)) continue;
            list.add(analyzerResult);
        }
        return list;
    }

    @Override
    public AnalyzerResult getResult(ComponentJob queryComponentJob) {
        Map<ComponentJob, AnalyzerResult> resultMap = this.getResultMap();
        AnalyzerResult analyzerResult = resultMap.get(queryComponentJob);
        if (analyzerResult == null && queryComponentJob instanceof AnalyzerJob) {
            AnalyzerJob queryAnalyzerJob = (AnalyzerJob)queryComponentJob;
            ArrayList<AnalyzerJob> analyzerJobs = new ArrayList<AnalyzerJob>();
            Set<Map.Entry<ComponentJob, AnalyzerResult>> entries = resultMap.entrySet();
            for (Map.Entry<ComponentJob, AnalyzerResult> entry : entries) {
                ComponentJob componentJob = entry.getKey();
                if (!(componentJob instanceof AnalyzerJob)) continue;
                analyzerJobs.add((AnalyzerJob)componentJob);
            }
            AnalyzerJobHelper helper = new AnalyzerJobHelper(analyzerJobs);
            AnalyzerJob analyzerJob = helper.getAnalyzerJob(queryAnalyzerJob);
            if (analyzerJob != null && analyzerJob != queryComponentJob) {
                analyzerResult = resultMap.get(analyzerJob);
            }
        }
        return analyzerResult;
    }
}

