/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Predicate;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.result.TableModelResult;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotations;

public class AnnotatedRowsResult
implements AnalyzerResult,
TableModelResult {
    private static final long serialVersionUID = 1L;
    private final Ref<RowAnnotationFactory> _annotationFactoryRef;
    private final InputColumn<?>[] _highlightedColumns;
    private final RowAnnotation _annotation;
    private transient List<InputRow> _rows;
    private transient TableModel _tableModel;
    private transient List<InputColumn<?>> _inputColumns;

    public static AnnotatedRowsResult createIfSampleRowsAvailable(RowAnnotation annotation, RowAnnotationFactory annotationFactory, InputColumn<?> ... columns) {
        if (annotationFactory.hasSampleRows(annotation)) {
            return new AnnotatedRowsResult(annotation, annotationFactory, columns);
        }
        return null;
    }

    public AnnotatedRowsResult(RowAnnotation annotation, RowAnnotationFactory annotationFactory, InputColumn<?> ... highlightedColumns) {
        this._annotationFactoryRef = new SerializableRef((Object)annotationFactory);
        this._annotation = annotation;
        this._highlightedColumns = highlightedColumns;
    }

    public List<InputColumn<?>> getInputColumns() {
        if (this._inputColumns == null) {
            List<InputRow> rows = this.getSampleRows();
            if (!rows.isEmpty()) {
                InputRow firstRow = rows.iterator().next();
                List inputColumns = firstRow.getInputColumns();
                this._inputColumns = CollectionUtils.filter((Iterable)inputColumns, (Predicate)new Predicate<InputColumn<?>>(){

                    public Boolean eval(InputColumn<?> col) {
                        if (col instanceof MutableInputColumn && ((MutableInputColumn)col).isHidden()) {
                            return false;
                        }
                        return true;
                    }
                });
            } else {
                this._inputColumns = new ArrayList(0);
            }
        }
        return this._inputColumns;
    }

    @Deprecated
    public InputRow[] getRows() {
        return this.getSampleRows().toArray(new InputRow[0]);
    }

    public List<InputRow> getSampleRows() {
        if (this._rows == null) {
            RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
            if (annotationFactory != null) {
                this._rows = annotationFactory.getSampleRows(this.getAnnotation());
            }
            if (this._rows == null) {
                this._rows = Collections.emptyList();
            }
        }
        return this._rows;
    }

    public TableModel toDistinctValuesTableModel(InputColumn<?> inputColumnOfInterest) {
        RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        Map<Object, Object> valueCounts = annotationFactory == null ? Collections.emptyMap() : this.getValueCounts(annotationFactory, this.getAnnotation(), inputColumnOfInterest);
        DefaultTableModel tableModel = new DefaultTableModel(new String[]{inputColumnOfInterest.getName(), "Count in dataset"}, valueCounts.size());
        TreeSet<Map.Entry<Object, Integer>> set = new TreeSet<Map.Entry<Object, Integer>>(new Comparator<Map.Entry<Object, Integer>>(){

            @Override
            public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
                int countDiff = o2.getValue() - o1.getValue();
                if (countDiff == 0) {
                    return -1;
                }
                return countDiff;
            }
        });
        set.addAll(valueCounts.entrySet());
        int i = 0;
        for (Map.Entry<Object, Integer> entry : set) {
            tableModel.setValueAt(entry.getKey(), i, 0);
            tableModel.setValueAt(entry.getValue(), i, 1);
            ++i;
        }
        return tableModel;
    }

    private Map<Object, Integer> getValueCounts(RowAnnotationFactory annotationFactory, RowAnnotation annotation, InputColumn<?> inputColumn) {
        List rows = annotationFactory.getSampleRows(annotation);
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (InputRow row : rows) {
            Object value = row.getValue(inputColumn);
            Integer count = map.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            map.put(value, count);
        }
        return map;
    }

    public TableModel toTableModel(int maxRows) {
        if (maxRows < 0) {
            maxRows = Integer.MAX_VALUE;
        }
        List<InputRow> rows = this.getSampleRows();
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        Object[] headers = new String[inputColumns.size()];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = inputColumns.get(i).getName();
        }
        int actualRows = Math.min(maxRows, rows.size());
        DefaultTableModel tableModel = new DefaultTableModel(headers, actualRows);
        int row = 0;
        for (InputRow inputRow : rows) {
            if (actualRows == row) break;
            for (int i = 0; i < inputColumns.size(); ++i) {
                InputColumn<?> inputColumn = inputColumns.get(i);
                Object value = inputRow.getValue(inputColumn);
                tableModel.setValueAt(value, row, i);
            }
            ++row;
        }
        return tableModel;
    }

    @Override
    public TableModel toTableModel() {
        if (this._tableModel == null) {
            this._tableModel = this.toTableModel(-1);
        }
        return this._tableModel;
    }

    public InputColumn<?>[] getHighlightedColumns() {
        return this._highlightedColumns;
    }

    public int getColumnIndex(InputColumn<?> col) {
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        int i = 0;
        for (InputColumn<?> inputColumn : inputColumns) {
            if (col.equals(inputColumn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public RowAnnotation getAnnotation() {
        if (this._annotation == null) {
            return RowAnnotations.getDefaultFactory().createAnnotation();
        }
        return this._annotation;
    }

    public int getAnnotatedRowCount() {
        return this.getAnnotation().getRowCount();
    }
}

