/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Metric;
import org.datacleaner.api.ParameterizableMetric;
import org.datacleaner.result.AnnotatedRowsResult;
import org.datacleaner.result.CategorizationResultReducer;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationImpl;

@Distributed(reducer=CategorizationResultReducer.class)
public class CategorizationResult
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final Ref<RowAnnotationFactory> _annotationFactoryRef;
    private final Map<String, RowAnnotation> _categories;

    public CategorizationResult(RowAnnotationFactory annotationFactory, Collection<Map.Entry<String, RowAnnotation>> categories) {
        this._annotationFactoryRef = new SerializableRef((Object)annotationFactory);
        this._categories = new LinkedHashMap<String, RowAnnotation>();
        for (Map.Entry<String, RowAnnotation> entry : categories) {
            this._categories.put(entry.getKey(), entry.getValue());
        }
    }

    public CategorizationResult(RowAnnotationFactory annotationFactory, Map<String, RowAnnotation> categories) {
        this._annotationFactoryRef = new SerializableRef((Object)annotationFactory);
        this._categories = categories;
    }

    @Metric(value="Category count")
    public ParameterizableMetric getCategoryCount() {
        return new ParameterizableMetric(){

            public Number getValue(String parameter) {
                return CategorizationResult.this.getCategoryCount(parameter);
            }

            public Collection<String> getParameterSuggestions() {
                return CategorizationResult.this.getCategoryNames();
            }
        };
    }

    public Collection<String> getCategoryNames() {
        return this._categories.keySet();
    }

    public int getCategoryCount(String category) {
        RowAnnotation annotation = this.getCategoryRowAnnotation(category);
        return annotation.getRowCount();
    }

    public AnnotatedRowsResult getCategoryRowSample(String category) {
        RowAnnotationFactory rowAnnotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        if (rowAnnotationFactory == null) {
            return null;
        }
        RowAnnotation annotation = this._categories.get(category);
        if (annotation == null) {
            return null;
        }
        return new AnnotatedRowsResult(annotation, rowAnnotationFactory, new InputColumn[0]);
    }

    public RowAnnotation getCategoryRowAnnotation(String category) {
        RowAnnotation annotation = this._categories.get(category);
        if (annotation == null) {
            return new RowAnnotationImpl();
        }
        return annotation;
    }
}

