/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.api.Provided;
import org.datacleaner.result.CategorizationResult;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;

public class CategorizationResultReducer
implements AnalyzerResultReducer<CategorizationResult> {
    @Inject
    @Provided
    RowAnnotationFactory _rowAnnotationFactory;

    public CategorizationResult reduce(Collection<? extends CategorizationResult> results) {
        RowAnnotationFactory annotationFactory = null;
        LinkedHashMap<String, RowAnnotation> reducedCategories = new LinkedHashMap<String, RowAnnotation>();
        for (CategorizationResult categorizationResult : results) {
            Collection<String> categoryNames = categorizationResult.getCategoryNames();
            for (String categoryName : categoryNames) {
                RowAnnotation partialAnnotation = categorizationResult.getCategoryRowAnnotation(categoryName);
                RowAnnotation reducedAnnotation = (RowAnnotation)reducedCategories.get(categoryName);
                if (reducedAnnotation == null) {
                    RowAnnotation annotation = this._rowAnnotationFactory.createAnnotation();
                    this._rowAnnotationFactory.transferAnnotations(partialAnnotation, annotation);
                    reducedCategories.put(categoryName, annotation);
                    continue;
                }
                this._rowAnnotationFactory.transferAnnotations(partialAnnotation, reducedAnnotation);
            }
        }
        return new CategorizationResult(annotationFactory, reducedCategories);
    }
}

