/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Metric;

public class ListResult<E>
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final List<E> _values;

    public ListResult(List<E> values) {
        this._values = values;
    }

    public ListResult(Collection<E> values) {
        this._values = values instanceof List ? (List)values : new ArrayList<E>(values);
    }

    public List<E> getValues() {
        return this._values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (E value : this._values) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    @Metric(order=1, value="Row count")
    public int getTotalRowCount() {
        return this._values.size();
    }
}

