/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import org.datacleaner.api.RendererBean;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.CrosstabDimension;
import org.datacleaner.result.CrosstabResult;
import org.datacleaner.result.ResultProducer;
import org.datacleaner.result.renderer.AbstractRenderer;
import org.datacleaner.result.renderer.CrosstabRenderer;
import org.datacleaner.result.renderer.CrosstabRendererCallback;
import org.datacleaner.result.renderer.TextRenderingFormat;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.ReflectionUtils;

@RendererBean(value=TextRenderingFormat.class)
public class CrosstabTextRenderer
extends AbstractRenderer<CrosstabResult, String> {
    public String render(CrosstabResult result) {
        return this.render(result.getCrosstab());
    }

    public String render(Crosstab<?> crosstab) {
        return new CrosstabRenderer(crosstab).render(new TextCrosstabRendererCallback());
    }

    public static NumberFormat getUiNumberFormat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("###.##", symbols);
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(2);
        return format;
    }

    private static class TextCrosstabRendererCallback
    implements CrosstabRendererCallback<String> {
        private final NumberFormat decimalFormat = CrosstabTextRenderer.getUiNumberFormat();
        private boolean leftAligned;
        private StringBuilder sb;
        private int horizontalDimensionWidth;

        private TextCrosstabRendererCallback() {
        }

        @Override
        public void beginTable(Crosstab<?> crosstab, List<CrosstabDimension> horizontalDimensions, List<CrosstabDimension> verticalDimensions) {
            this.sb = new StringBuilder();
            this.horizontalDimensionWidth = 0;
            for (CrosstabDimension dimension : horizontalDimensions) {
                List<String> categories = dimension.getCategories();
                for (String category : categories) {
                    this.horizontalDimensionWidth = Math.max(this.horizontalDimensionWidth, category.length());
                }
            }
            this.horizontalDimensionWidth = Math.max(this.horizontalDimensionWidth, 6);
            this.leftAligned = !ReflectionUtils.is(crosstab.getValueClass(), Number.class);
        }

        @Override
        public void endTable() {
        }

        @Override
        public void beginRow() {
        }

        @Override
        public void endRow() {
            this.sb.append('\n');
        }

        @Override
        public void horizontalHeaderCell(String category, CrosstabDimension dimension, int width) {
            int trailingBlanks = this.horizontalDimensionWidth * width - category.length();
            if (this.leftAligned) {
                this.sb.append(category);
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
            } else {
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
                this.sb.append(category);
            }
            this.sb.append(' ');
        }

        @Override
        public void verticalHeaderCell(String category, CrosstabDimension dimension, int height) {
            this.sb.append(category);
            int dimensionWidth = this.getWidth(dimension);
            dimensionWidth -= category.length();
            for (int i = 0; i < dimensionWidth; ++i) {
                this.sb.append(' ');
            }
            this.sb.append(' ');
        }

        @Override
        public void valueCell(Object value, ResultProducer drillToDetailResultProducer) {
            boolean leftAligned = this.leftAligned;
            String stringValue = value == null ? null : value.toString();
            stringValue = LabelUtils.getValueLabel(stringValue);
            if (value instanceof Number) {
                leftAligned = false;
                if (value instanceof Double || value instanceof Float) {
                    stringValue = this.decimalFormat.format(value);
                }
            }
            int trailingBlanks = this.horizontalDimensionWidth - stringValue.length();
            if (leftAligned) {
                this.sb.append(stringValue);
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
            } else {
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
                this.sb.append(stringValue);
            }
            this.sb.append(' ');
        }

        @Override
        public void emptyHeader(CrosstabDimension verticalDimension, CrosstabDimension horizontalDimension) {
            int dimensionWidth = this.getWidth(verticalDimension);
            for (int i = 0; i < dimensionWidth; ++i) {
                this.sb.append(' ');
            }
            this.sb.append(' ');
        }

        private int getWidth(CrosstabDimension verticalDimension) {
            List<String> categories = verticalDimension.getCategories();
            int longestCategory = 0;
            for (String category : categories) {
                longestCategory = Math.max(longestCategory, category.length());
            }
            return longestCategory;
        }

        @Override
        public String getResult() {
            if (this.sb == null) {
                return "";
            }
            return this.sb.toString();
        }
    }
}

