/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.save;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.result.AnalysisResult;
import org.datacleaner.result.SimpleAnalysisResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisResultSaveHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisResultSaveHandler.class);
    private final AnalysisResult _analysisResult;
    private final Resource _resource;
    private Map<ComponentJob, AnalyzerResult> _unsafeResultElements;

    public AnalysisResultSaveHandler(AnalysisResult analysisResult, Resource resource) {
        this._analysisResult = analysisResult;
        this._resource = resource;
    }

    public boolean saveAttempt() {
        try {
            this.saveOrThrow();
            return true;
        }
        catch (SerializationException e) {
            return false;
        }
    }

    public void saveWithoutUnsafeResultElements() {
        AnalysisResult safeAnalysisResult = this.createSafeAnalysisResult();
        AnalysisResultSaveHandler.saveOrThrow(safeAnalysisResult, this._resource);
    }

    public void saveOrThrow() throws SerializationException {
        AnalysisResultSaveHandler.saveOrThrow(this._analysisResult, this._resource);
    }

    private static void saveOrThrow(AnalysisResult analysisResult, Resource resource) {
        SimpleAnalysisResult simpleAnalysisResult = analysisResult instanceof SimpleAnalysisResult ? (SimpleAnalysisResult)analysisResult : new SimpleAnalysisResult(analysisResult.getResultMap(), analysisResult.getCreationDate());
        OutputStream out = resource.write();
        try {
            SerializationUtils.serialize((Serializable)simpleAnalysisResult, (OutputStream)out);
        }
        catch (SerializationException e) {
            try {
                logger.error("Error serializing analysis result: " + analysisResult, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{out});
    }

    public Map<ComponentJob, AnalyzerResult> getUnsafeResultElements() {
        if (this._unsafeResultElements == null) {
            this._unsafeResultElements = new LinkedHashMap<ComponentJob, AnalyzerResult>();
            Map<ComponentJob, AnalyzerResult> resultMap = this._analysisResult.getResultMap();
            for (Map.Entry<ComponentJob, AnalyzerResult> entry : resultMap.entrySet()) {
                AnalyzerResult analyzerResult = entry.getValue();
                try {
                    SerializationUtils.serialize((Serializable)analyzerResult, (OutputStream)new NullOutputStream());
                }
                catch (SerializationException e) {
                    this._unsafeResultElements.put(entry.getKey(), analyzerResult);
                }
            }
        }
        return this._unsafeResultElements;
    }

    public AnalysisResult createSafeAnalysisResult() {
        Set<ComponentJob> unsafeKeys = this.getUnsafeResultElements().keySet();
        if (unsafeKeys.isEmpty()) {
            return this._analysisResult;
        }
        LinkedHashMap<ComponentJob, AnalyzerResult> resultMap = new LinkedHashMap<ComponentJob, AnalyzerResult>(this._analysisResult.getResultMap());
        for (ComponentJob unsafeKey : unsafeKeys) {
            resultMap.remove(unsafeKey);
        }
        if (resultMap.isEmpty()) {
            return null;
        }
        return new SimpleAnalysisResult(resultMap, this._analysisResult.getCreationDate());
    }
}

