/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.server;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.datacleaner.server.AbstractServerInformation;
import org.datacleaner.server.HadoopClusterInformation;

public class DirectoryBasedHadoopClusterInformation
extends AbstractServerInformation
implements HadoopClusterInformation {
    private static final long serialVersionUID = 1L;
    private final String[] _directories;

    public DirectoryBasedHadoopClusterInformation(String name, String description, String ... paths) {
        super(name, description);
        this._directories = paths;
    }

    @Override
    public Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        HashMap configurationFiles = new HashMap();
        Arrays.stream(this.getDirectories()).map(File::new).filter(File::isDirectory).forEach(c -> {
            File[] array = c.listFiles();
            assert (array != null);
            Arrays.stream(array).filter(File::isFile).filter(f -> !configurationFiles.containsKey(f.getName())).filter(f -> FilenameUtils.getExtension((String)f.getName()).equalsIgnoreCase("xml")).forEach(f -> configurationFiles.put(f.getName(), f));
        });
        if (configurationFiles.size() == 0) {
            throw new IllegalStateException("Specified directories does not contain any Hadoop configuration files");
        }
        configurationFiles.values().stream().map(File::toURI).map(Path::new).forEach(arg_0 -> ((Configuration)configuration).addResource(arg_0));
        return configuration;
    }

    public String[] getDirectories() {
        return this._directories;
    }
}

