/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.server;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.datacleaner.server.DirectoryBasedHadoopClusterInformation;
import org.datacleaner.server.HadoopClusterInformation;

public class EnvironmentBasedHadoopClusterInformation
extends DirectoryBasedHadoopClusterInformation
implements HadoopClusterInformation {
    private static final long serialVersionUID = 1L;
    public static final String YARN_CONF_DIR = "YARN_CONF_DIR";
    public static final String HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
    private static final String[] CONFIGURATION_VARIABLES = new String[]{"HADOOP_CONF_DIR", "YARN_CONF_DIR"};

    public EnvironmentBasedHadoopClusterInformation(String name, String description) {
        super(name, description, EnvironmentBasedHadoopClusterInformation.getConfigurationDirectories());
    }

    public static boolean isConfigurationDirectoriesSpecified() {
        return EnvironmentBasedHadoopClusterInformation.getConfigurationDirectories().length > 0;
    }

    private static String[] getConfigurationDirectories() {
        ArrayList<String> configDirectories = new ArrayList<String>();
        for (String configVariable : CONFIGURATION_VARIABLES) {
            String propertyValues = System.getProperty(configVariable);
            if (propertyValues == null) continue;
            configDirectories.add(propertyValues);
        }
        if (configDirectories.isEmpty()) {
            for (String configVariable : CONFIGURATION_VARIABLES) {
                String environmentValue = System.getenv(configVariable);
                if (environmentValue == null) continue;
                configDirectories.add(environmentValue);
            }
        }
        return configDirectories.toArray(new String[configDirectories.size()]);
    }

    @Override
    public Configuration getConfiguration() {
        try {
            return super.getConfiguration();
        }
        catch (IllegalStateException e) {
            if (this.getDirectories().length == 0) {
                throw new IllegalStateException("None of the standard Hadoop environment variables (HADOOP_CONF_DIR, YARN_CONF_DIR) has been set.", e);
            }
            throw e;
        }
    }
}

