/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.List;
import org.datacleaner.api.InputRow;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationHandler;
import org.datacleaner.storage.RowAnnotationImpl;
import org.datacleaner.storage.RowAnnotationSampleContainer;

public abstract class AbstractRowAnnotationFactory2
implements RowAnnotationFactory,
RowAnnotationSampleContainer,
RowAnnotationHandler {
    public final RowAnnotation createAnnotation() {
        return new RowAnnotationImpl();
    }

    public void resetAnnotation(RowAnnotation annotation) {
        RowAnnotationImpl annotationImpl = (RowAnnotationImpl)annotation;
        annotationImpl.resetRowCount();
    }

    public void transferAnnotations(RowAnnotation from, RowAnnotation to) {
        RowAnnotationImpl fromImpl = (RowAnnotationImpl)from;
        RowAnnotationImpl toImpl = (RowAnnotationImpl)to;
        toImpl.incrementRowCount(fromImpl.getRowCount());
        fromImpl.resetRowCount();
    }

    public void annotate(InputRow row, RowAnnotation annotation) {
        RowAnnotationImpl annotationImpl = (RowAnnotationImpl)annotation;
        annotationImpl.incrementRowCount(1);
    }

    public void annotate(InputRow row, int distinctCount, RowAnnotation annotation) {
        for (int i = 0; i < distinctCount; ++i) {
            this.annotate(row, annotation);
        }
    }

    public boolean hasSampleRows(RowAnnotation annotation) {
        List sampleRows = this.getSampleRows(annotation);
        return sampleRows != null && !sampleRows.isEmpty();
    }
}

