/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.storage.CollectionFactory;
import org.datacleaner.storage.StorageProvider;

public final class CollectionFactoryImpl
implements CollectionFactory {
    private final StorageProvider _storageProvider;
    private final List<Object> _collections = new ArrayList<Object>();

    public CollectionFactoryImpl(StorageProvider storageProvider) {
        this._storageProvider = storageProvider;
    }

    @Override
    public <E> List<E> createList(Class<E> elementClass) {
        List list = this._storageProvider.createList(elementClass);
        this._collections.add(list);
        return list;
    }

    @Override
    public <E> Set<E> createSet(Class<E> elementClass) {
        Set set = this._storageProvider.createSet(elementClass);
        this._collections.add(set);
        return set;
    }

    @Override
    public <K, V> Map<K, V> createMap(Class<K> keyClass, Class<V> valueClass) {
        Map map = this._storageProvider.createMap(keyClass, valueClass);
        this._collections.add(map);
        return map;
    }
}

