/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.datacleaner.api.InputRow;
import org.datacleaner.storage.AbstractRowAnnotationFactory2;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;

public final class InMemoryRowAnnotationFactory2
extends AbstractRowAnnotationFactory2
implements RowAnnotationFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SAMPLE_LIMIT = 250000;
    private final ConcurrentHashMap<RowAnnotation, List<InputRow>> _storage = new ConcurrentHashMap();
    private final int _maxSampleRecords;
    private final int _maxSampleSets;

    public InMemoryRowAnnotationFactory2() {
        this(500);
    }

    public InMemoryRowAnnotationFactory2(int maxSampleRecords) {
        this(Math.min(10, 250000 / maxSampleRecords), 500);
    }

    public InMemoryRowAnnotationFactory2(int maxSampleSets, int maxSampleRecords) {
        this._maxSampleSets = Math.max(0, maxSampleSets);
        this._maxSampleRecords = Math.max(0, maxSampleRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInputRowsToCollection(Collection<InputRow> rowCollection, Collection<InputRow> rows) {
        if (rowCollection == null) {
            return;
        }
        int size = rowCollection.size();
        if (size >= this._maxSampleRecords) {
            return;
        }
        for (InputRow inputRow : rows) {
            Collection<InputRow> collection = rowCollection;
            synchronized (collection) {
                rowCollection.add(inputRow);
                if (++size >= this._maxSampleRecords) {
                    return;
                }
            }
        }
    }

    private Collection<InputRow> getInputRowCollection(int defaultSize, RowAnnotation annotation) {
        List<InputRow> rowCollection = this._storage.get(annotation);
        if (rowCollection == null) {
            if (this._storage.size() >= this._maxSampleSets) {
                return null;
            }
            rowCollection = new ArrayList<InputRow>(defaultSize);
            List<InputRow> existingCollection = this._storage.putIfAbsent(annotation, rowCollection);
            if (existingCollection != null) {
                rowCollection = existingCollection;
            }
        }
        return rowCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotate(InputRow row, RowAnnotation annotation) {
        super.annotate(row, annotation);
        Collection<InputRow> rowCollection = this.getInputRowCollection(10, annotation);
        if (rowCollection != null) {
            Collection<InputRow> collection = rowCollection;
            synchronized (collection) {
                if (rowCollection.size() >= this._maxSampleRecords) {
                    return;
                }
                rowCollection.add(row);
            }
        }
    }

    @Override
    public void resetAnnotation(RowAnnotation annotation) {
        super.resetAnnotation(annotation);
        this._storage.remove(annotation);
    }

    public List<InputRow> getSampleRows(RowAnnotation annotation) {
        List<InputRow> collection = this._storage.get(annotation);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(collection);
    }

    @Override
    public void transferAnnotations(RowAnnotation from, RowAnnotation to) {
        super.transferAnnotations(from, to);
        Collection fromCollection = this._storage.get(from);
        if (fromCollection == null || fromCollection.isEmpty()) {
            return;
        }
        Collection<InputRow> toCollection = this.getInputRowCollection(fromCollection.size(), to);
        this.addInputRowsToCollection(toCollection, fromCollection);
        this._storage.remove(from);
    }

    @Override
    public boolean hasSampleRows(RowAnnotation annotation) {
        return this._storage.containsKey(annotation);
    }
}

