/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotations;
import org.datacleaner.storage.StorageProvider;

public final class InMemoryStorageProvider
implements StorageProvider {
    public static final int DEFAULT_MAX_SAMPLE_SETS = 1000;
    public static final int DEFAULT_MAX_SAMPLE_RECORDS = 150;
    private final int _maxSampleSets;
    private final int _maxSampleRecords;

    public InMemoryStorageProvider() {
        this(1000, 150);
    }

    public InMemoryStorageProvider(int maxSampleRecords) {
        this(Math.min(10, 150000 / maxSampleRecords), maxSampleRecords);
    }

    public InMemoryStorageProvider(int maxSampleSets, int maxSampleRecords) {
        this._maxSampleSets = Math.max(0, maxSampleSets);
        this._maxSampleRecords = Math.max(0, maxSampleRecords);
    }

    public <E> List<E> createList(Class<E> valueType) throws IllegalStateException {
        return new ArrayList();
    }

    public <K, V> Map<K, V> createMap(Class<K> keyType, Class<V> valueType) throws IllegalStateException {
        return new HashMap();
    }

    public <E> Set<E> createSet(Class<E> valueType) throws IllegalStateException {
        return new HashSet();
    }

    public RowAnnotationFactory createRowAnnotationFactory() {
        return RowAnnotations.getInMemoryFactory(this._maxSampleSets, this._maxSampleRecords);
    }
}

