/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrencyUtils.class);
    private static final int AWAIT_TIMEOUT_MINUTES = 2;

    private ConcurrencyUtils() {
    }

    public static void awaitCountDown(CountDownLatch countDownLatch, String countDownLatchId) {
        int iteration = 0;
        try {
            boolean finished = false;
            while (!finished) {
                ++iteration;
                finished = countDownLatch.await(2L, TimeUnit.MINUTES);
                if (finished) continue;
                logger.info("Awaited completion of '" + countDownLatchId + "' for " + iteration * 2 + " minutes...");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Awaiting completion of '" + countDownLatchId + "' was interrupted!", e);
        }
    }
}

