/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.CrosstabDimension;
import org.datacleaner.result.CrosstabNavigator;

public class CrosstabReducerHelper {
    public static void createDimensionsColumnCrosstab(List<CrosstabDimension> crosstabDimensions, Crosstab<Number> partialCrosstab) {
        if (partialCrosstab != null) {
            List<CrosstabDimension> dimensions = partialCrosstab.getDimensions();
            for (CrosstabDimension dimension : dimensions) {
                if (CrosstabReducerHelper.dimensionExits(crosstabDimensions, dimension)) continue;
                crosstabDimensions.add(dimension);
            }
        }
    }

    public static boolean dimensionExits(Collection<CrosstabDimension> list, CrosstabDimension dimension) {
        if (list.size() > 0) {
            boolean allreadyExits = false;
            for (CrosstabDimension dim : list) {
                if (!dimension.equals(dim)) continue;
                allreadyExits = true;
                break;
            }
            return allreadyExits;
        }
        return false;
    }

    public static void addData(Crosstab<Number> mainCrosstab, Crosstab<Number> partialCrosstab, CrosstabDimension columnDimension, CrosstabDimension measureDimension) {
        if (partialCrosstab != null) {
            CrosstabNavigator<Number> mainNavigator = new CrosstabNavigator<Number>(mainCrosstab);
            CrosstabNavigator<Number> nav = new CrosstabNavigator<Number>(partialCrosstab);
            for (String columnCategory : columnDimension.getCategories()) {
                nav.where(columnDimension, columnCategory);
                mainNavigator.where(columnDimension, columnCategory);
                List<String> categories = measureDimension.getCategories();
                for (String measureCategory : categories) {
                    CrosstabReducerHelper.sumUpData(mainNavigator, nav, measureDimension, measureCategory);
                }
            }
        }
    }

    private static void sumUpData(CrosstabNavigator<Number> mainNavigator, CrosstabNavigator<Number> nav, CrosstabDimension dimension, String category) {
        CrosstabNavigator<Number> where = nav.where(dimension, category);
        CrosstabNavigator<Number> whereToPut = mainNavigator.where(dimension, category);
        Number categoryValue = where.safeGet(null);
        if (categoryValue != null) {
            Number oldValue = whereToPut.safeGet(null);
            if (oldValue != null) {
                Number newValue = CrosstabReducerHelper.sum(oldValue, categoryValue);
                whereToPut.put(newValue);
            } else {
                whereToPut.put(categoryValue);
            }
        }
    }

    public static boolean findDimension(Crosstab<Number> crosstab, String dimensionName) {
        try {
            CrosstabDimension dimension = crosstab.getDimension(dimensionName);
            if (dimension == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Number sum(Number n1, Number n2) {
        if (CrosstabReducerHelper.isIntegerType(n1) && CrosstabReducerHelper.isIntegerType(n2)) {
            return BigInteger.valueOf(n1.longValue()).add(BigInteger.valueOf(n2.longValue()));
        }
        return new BigDecimal(n1.doubleValue()).add(new BigDecimal(n2.doubleValue()));
    }

    public static Number subtract(Number n1, Number n2) {
        if (CrosstabReducerHelper.isIntegerType(n1) && CrosstabReducerHelper.isIntegerType(n2)) {
            return BigInteger.valueOf(n1.longValue()).subtract(BigInteger.valueOf(n2.longValue()));
        }
        return new BigDecimal(n1.doubleValue()).subtract(new BigDecimal(n2.doubleValue()));
    }

    private static boolean isIntegerType(Number n) {
        return n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof BigInteger;
    }
}

