/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.util.StringUtils;

public class FileResolver {
    private final File _baseDir;

    public FileResolver(DataCleanerConfiguration configuration) {
        this(configuration == null ? null : configuration.getHomeFolder());
    }

    public FileResolver(DataCleanerHomeFolder homeFolder) {
        this._baseDir = homeFolder == null ? DataCleanerConfigurationImpl.defaultHomeFolder().toFile() : homeFolder.toFile();
    }

    public FileResolver(File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("Base directory cannot be null");
        }
        this._baseDir = baseDir;
    }

    public File getBaseDirectory() {
        return this._baseDir;
    }

    public File toFile(String filename) {
        File nonParentCandidate;
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim()).toLowerCase().startsWith("file://")) {
            filename = filename.substring("file://".length());
        }
        File file = (nonParentCandidate = new File(filename)).isAbsolute() ? nonParentCandidate : (this._baseDir == null || ".".equals(this._baseDir.getPath()) ? nonParentCandidate : new File(this._baseDir, filename));
        return file;
    }

    public String toPath(File file) {
        boolean absolute;
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String basePath = FilenameUtils.normalize((String)this._baseDir.getAbsolutePath(), (boolean)true);
        String filePath = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
        if (filePath.startsWith(basePath)) {
            path = filePath.substring(basePath.length());
            absolute = false;
        } else {
            absolute = file.isAbsolute();
        }
        path = StringUtils.replaceAll(path, "\\", "/");
        if (!absolute) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
        }
        return path;
    }
}

