/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.metamodel.util.HdfsResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.server.HadoopClusterInformation;

public class HadoopResource
extends HdfsResource {
    public static final String DEFAULT_CLUSTERREFERENCE = "org.datacleaner.hadoop.environment";
    private static final long serialVersionUID = 1L;
    private final transient Configuration _configuration;
    private final String _clusterReferenceName;

    public HadoopResource(URI uri, Configuration configuration, String clusterReferenceName) {
        super(uri.toString());
        this._configuration = configuration;
        this._clusterReferenceName = clusterReferenceName;
    }

    public HadoopResource(Resource resource, Configuration configuration, String clusterReferenceName) {
        super(resource.getQualifiedPath());
        this._configuration = configuration;
        this._clusterReferenceName = clusterReferenceName;
    }

    public HadoopResource(URI uri, HadoopClusterInformation defaultCluster) {
        this(uri, defaultCluster.getConfiguration(), defaultCluster.getName());
    }

    public HadoopResource(String uri, Configuration configuration, String clusterReferenceName) {
        super(uri);
        this._configuration = configuration;
        this._clusterReferenceName = clusterReferenceName;
    }

    public Configuration getHadoopConfiguration() {
        return this._configuration;
    }

    public String toString() {
        return "HadoopResource[" + this.getQualifiedPath() + "]";
    }

    public String getClusterReferenceName() {
        return this._clusterReferenceName;
    }

    public String getTemplatedPath() {
        if (this._clusterReferenceName == null) {
            return this.getQualifiedPath();
        }
        return "hdfs://{" + this._clusterReferenceName + "}" + this.getFilepath();
    }
}

