/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.components.maxrows.MaxRowsFilter;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerComponentBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.util.SourceColumnFinder;

public class PreviewUtils {
    public static final String METADATA_PROPERTY_MARKER = "org.datacleaner.preview.targetcomponent";

    public static void limitJobRows(AnalysisJobBuilder jobBuilder, Collection<? extends ComponentBuilder> componentBuilders, int previewRows) {
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(jobBuilder);
        List<Table> sourceTables = jobBuilder.getSourceTables();
        int maxRows = Double.valueOf(Math.ceil((double)previewRows / (double)sourceTables.size())).intValue();
        for (Table table : sourceTables) {
            String filterName = PreviewUtils.class.getName() + "-" + table.getName() + "-MaxRows";
            FilterComponentBuilder maxRowFilter = jobBuilder.getFilterComponentBuilderByName(filterName).orElseGet(() -> {
                FilterComponentBuilder filter = jobBuilder.addFilter(MaxRowsFilter.class);
                filter.setName(filterName);
                ((MaxRowsFilter)filter.getComponentInstance()).setMaxRows(maxRows);
                ((MaxRowsFilter)filter.getComponentInstance()).setApplyOrdering(false);
                ((MaxRowsFilter)filter.getComponentInstance()).setOrderColumn(jobBuilder.getSourceColumnsOfTable(table).get(0));
                return filter;
            });
            componentBuilders.stream().filter(cb -> cb != maxRowFilter).forEach(componentBuilder -> {
                InputColumn[] input = componentBuilder.getInput();
                if (input.length > 0 && (componentBuilder.getDescriptor().isMultiStreamComponent() || sourceColumnFinder.findOriginatingTable(input[0]) == table)) {
                    ComponentRequirement existingRequirement = componentBuilder.getComponentRequirement();
                    if (existingRequirement != null) {
                        if (componentBuilder.getDescriptor().isMultiStreamComponent()) {
                            componentBuilder.setComponentRequirement(new CompoundComponentRequirement(existingRequirement, maxRowFilter.getFilterOutcome((Object)MaxRowsFilter.Category.VALID)));
                        }
                    } else {
                        componentBuilder.setComponentRequirement(new SimpleComponentRequirement(maxRowFilter.getFilterOutcome((Object)MaxRowsFilter.Category.VALID)));
                    }
                }
            });
        }
    }

    public static AnalysisJobBuilder copy(AnalysisJobBuilder original) {
        AnalysisJob analysisJob = original.getRootJobBuilder().withoutListeners().toAnalysisJob(false);
        return new AnalysisJobBuilder(original.getConfiguration(), analysisJob);
    }

    public static void sanitizeIrrelevantComponents(AnalysisJobBuilder ajb, TransformerComponentBuilder<?> tjb) {
        List<AnalysisJobBuilder> relevantAnalysisJobBuilders = PreviewUtils.createRelevantAnalysisJobBuildersList(ajb);
        for (AnalysisJobBuilder relevantAnalysisJobBuilder : relevantAnalysisJobBuilders) {
            Collection<ComponentBuilder> componentBuilders = relevantAnalysisJobBuilder.getComponentBuilders();
            for (ComponentBuilder componentBuilder : componentBuilders) {
                boolean importantComponent = componentBuilder == tjb;
                List<OutputDataStream> streams = componentBuilder.getOutputDataStreams();
                for (OutputDataStream stream : streams) {
                    if (!componentBuilder.isOutputDataStreamConsumed(stream)) continue;
                    AnalysisJobBuilder childJobBuilder = componentBuilder.getOutputDataStreamJobBuilder(stream);
                    if (relevantAnalysisJobBuilders.contains(childJobBuilder)) {
                        importantComponent = true;
                        continue;
                    }
                    childJobBuilder.removeAllComponents();
                }
                if (!importantComponent && componentBuilder instanceof AnalyzerComponentBuilder) {
                    relevantAnalysisJobBuilder.removeComponent(componentBuilder);
                }
                if (importantComponent || componentBuilder.isConfigured(false)) continue;
                relevantAnalysisJobBuilder.removeComponent(componentBuilder);
            }
        }
    }

    private static List<AnalysisJobBuilder> createRelevantAnalysisJobBuildersList(AnalysisJobBuilder ajb) {
        LinkedList<AnalysisJobBuilder> relevantAnalysisJobBuilders = new LinkedList<AnalysisJobBuilder>();
        relevantAnalysisJobBuilders.add(ajb);
        while (!ajb.isRootJobBuilder()) {
            ajb = ajb.getParentJobBuilder();
        }
        return relevantAnalysisJobBuilders;
    }

    public static AnalysisJobBuilder findAnalysisJobBuilder(AnalysisJobBuilder analysisJobBuilder, String jobBuilderIdentifier) {
        if (jobBuilderIdentifier.equals(analysisJobBuilder.getAnalysisJobMetadata().getProperties().get(METADATA_PROPERTY_MARKER))) {
            return analysisJobBuilder;
        }
        List<AnalysisJobBuilder> childJobBuilders = analysisJobBuilder.getConsumedOutputDataStreamsJobBuilders();
        for (AnalysisJobBuilder childJobBuilder : childJobBuilders) {
            AnalysisJobBuilder result = PreviewUtils.findAnalysisJobBuilder(childJobBuilder, jobBuilderIdentifier);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean hasFilterPresent(SourceColumnFinder scf, ComponentBuilder acb) {
        return scf.findAllSourceJobs(acb).stream().filter(o -> o instanceof HasFilterOutcomes).findAny().isPresent();
    }
}

